/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.builder.position;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.TreePartType;
import fr.rakambda.fallingtree.common.tree.builder.ToAnalyzePos;
import fr.rakambda.fallingtree.common.tree.builder.position.IPositionFetcher;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class BelowPositionFetcher
implements IPositionFetcher {
    private static BelowPositionFetcher INSTANCE;
    @NotNull
    private final FallingTreeCommon<?> mod;
    @NotNull
    private final Function<IBlockPos, IBlockPos> higherPosProvider;

    @Override
    @NotNull
    public Collection<ToAnalyzePos> getPositions(@NotNull ILevel level, @NotNull IBlockPos originPos, @NotNull ToAnalyzePos parent) {
        IBlockPos parentPos = parent.checkPos();
        IBlock parentBlock = level.getBlockState(parentPos).getBlock();
        return parentPos.betweenClosedStream(parentPos.below().south().west(), this.higherPosProvider.apply(parentPos).north().east()).map(checkPos -> {
            IBlockState checkedState = level.getBlockState((IBlockPos)checkPos);
            IBlockEntity checkedEntity = level.getBlockEntity((IBlockPos)checkPos);
            IBlock checkBlock = checkedState.getBlock();
            TreePartType treePart = this.mod.getTreePart(checkBlock);
            int logSequence = treePart.isLog() ? 0 : parent.sequenceSinceLastLog() + 1;
            return new ToAnalyzePos(this, parentPos, parentBlock, checkPos.immutable(), checkBlock, checkedState, checkedEntity, treePart, parent.sequence() + 1, logSequence);
        }).collect(Collectors.toList());
    }

    public static BelowPositionFetcher getInstance(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new BelowPositionFetcher(common, IBlockPos::below);
        }
        return INSTANCE;
    }

    @Generated
    private BelowPositionFetcher(@NotNull FallingTreeCommon<?> mod, @NotNull Function<IBlockPos, IBlockPos> higherPosProvider) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        if (higherPosProvider == null) {
            throw new NullPointerException("higherPosProvider is marked non-null but is null");
        }
        this.mod = mod;
        this.higherPosProvider = higherPosProvider;
    }
}

