/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.breaking;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.IBreakAttemptResult;
import fr.rakambda.fallingtree.common.tree.SuccessResult;
import fr.rakambda.fallingtree.common.tree.Tree;
import fr.rakambda.fallingtree.common.tree.TreePart;
import fr.rakambda.fallingtree.common.tree.TreePartType;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooSmallException;
import fr.rakambda.fallingtree.common.tree.breaking.ITreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.ToolDamageHandler;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.common.wrapper.IServerLevel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ShiftDownTreeBreakingHandler
implements ITreeBreakingHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(ShiftDownTreeBreakingHandler.class);
    private static ShiftDownTreeBreakingHandler INSTANCE;
    private final FallingTreeCommon<?> mod;

    @Override
    @NotNull
    public IBreakAttemptResult breakTree(boolean isCancellable, @NotNull IPlayer player, @NotNull Tree tree) throws BreakTreeTooBigException, BreakTreeTooSmallException {
        IItemStack tool = player.getMainHandItem();
        Optional<TreePart> treePartOptional = tree.getLastSequencePart();
        Optional<TreePart> treePartLogOptional = tree.getLastSequenceLogPart();
        if (treePartOptional.isEmpty() || treePartLogOptional.isEmpty()) {
            return SuccessResult.DO_NOT_CANCEL;
        }
        TreePart treePart = treePartOptional.get();
        TreePart treePartLog = treePartLogOptional.get();
        ILevel level = tree.getLevel();
        if (treePart.treePartType() == TreePartType.NETHER_WART && this.mod.getConfiguration().getTrees().isBreakNetherTreeWarts()) {
            return this.breakElements(isCancellable, tree, level, player, tool, treePartLog, tree.getNetherWarts());
        }
        if (treePart.treePartType() == TreePartType.MANGROVE_ROOTS && this.mod.getConfiguration().getTrees().isBreakMangroveRoots()) {
            return this.breakElements(isCancellable, tree, level, player, tool, treePartLog, tree.getMangroveRoots());
        }
        return this.breakElements(isCancellable, tree, level, player, tool, treePartLog, List.of());
    }

    @NotNull
    private IBreakAttemptResult breakElements(boolean isCancellable, @NotNull Tree tree, @NotNull ILevel level, @NotNull IPlayer player, @NotNull IItemStack tool, @NotNull TreePart logPart, @NotNull Collection<TreePart> leaves) throws BreakTreeTooBigException, BreakTreeTooSmallException {
        int count = leaves.size();
        double damageMultiplicand = this.mod.getConfiguration().getTools().getDamageMultiplicand();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, damageMultiplicand, this.mod.getConfiguration().getTools().getDurabilityMode(), count, this.mod.getConfiguration().getTrees().getMinSize(), this.mod.getConfiguration().getTrees().getMaxSize(), this.mod.getConfiguration().getTrees().getMaxSizeAction(), this.mod.getConfiguration().getTools().getDamageRounding());
        if (toolHandler.isPreserveTool()) {
            log.info("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.prevented_break_tool", new Object[0]));
            return SuccessResult.DO_NOT_CANCEL;
        }
        int breakCount = leaves.stream().limit(toolHandler.getMaxBreakCount()).mapToInt(part -> this.breakPart(tree, (TreePart)part, level, player, tool, true)).sum() + this.breakPart(tree, logPart, level, player, tool, isCancellable);
        int damage = toolHandler.getActualDamage(breakCount - (isCancellable ? 0 : 1));
        if (damage > 0) {
            tool.damage(damage, player);
        }
        if (breakCount == 0) {
            if (player.isCreative() && this.mod.getConfiguration().isLootInCreative()) {
                tree.getStart().ifPresent(part -> part.blockState().getBlock().playerDestroy(level, player, tree.getHitPos(), part.blockState(), part.blockEntity(), tool, true));
            }
            return SuccessResult.DO_NOT_CANCEL;
        }
        if (level instanceof IServerLevel) {
            IServerLevel serverLevel = (IServerLevel)level;
            serverLevel.spawnParticle(tree.getHitPos(), level.getBlockState(tree.getHitPos()), 10, 1.0f, 1.0f, 1.0f, 5.0f);
        }
        if (isCancellable) {
            return SuccessResult.CANCEL;
        }
        tree.getStart().ifPresent(part -> level.setBlock(part.blockPos(), part.blockState()));
        return SuccessResult.DO_NOT_CANCEL;
    }

    private int breakPart(@NotNull Tree tree, @NotNull TreePart treePart, @NotNull ILevel level, @NotNull IPlayer player, @NotNull IItemStack tool, boolean spawnLoot) {
        IBlockPos blockPos = treePart.blockPos();
        IBlockState logState = level.getBlockState(blockPos);
        if (treePart.treePartType() == TreePartType.LOG_START) {
            return 0;
        }
        if (!this.mod.checkCanBreakBlock(level, blockPos, logState, player)) {
            return 0;
        }
        player.awardItemUsed(tool.getItem());
        if (!player.isCreative() && spawnLoot || player.isCreative() && this.mod.getConfiguration().isLootInCreative()) {
            logState.getBlock().playerDestroy(level, player, tree.getHitPos(), logState, level.getBlockEntity(blockPos), tool, true);
        }
        level.removeBlock(blockPos, false);
        return 1;
    }

    @NotNull
    public static ShiftDownTreeBreakingHandler getInstance(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new ShiftDownTreeBreakingHandler(common);
        }
        return INSTANCE;
    }

    @Generated
    public ShiftDownTreeBreakingHandler(FallingTreeCommon<?> mod) {
        this.mod = mod;
    }
}

