/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class PlayerRenderer {
    private static final Map<UUID, GameProfile> PLAYER_PROFILE_MAP = new HashMap<UUID, GameProfile>();
    private static final HashSet<UUID> FETCH_QUEUE = new HashSet();

    public static void renderPlayerHead(UUID player, GuiGraphicsHelper graphics, int x, int y, int width, int height) {
        graphics.submitTexture(PlayerRenderer.getPlayerSkin(player), (float)x, (float)y, (float)width, (float)height, p -> p.uv(0.125f, 0.125f, 0.125f, 0.125f));
    }

    public static String getPlayerUsername(UUID player) {
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        return profile == null ? null : profile.getName();
    }

    public static class_2960 getPlayerSkin(UUID player) {
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        if (profile != null) {
            return ClientUtils.getMinecraft().method_1582().method_52862(profile).comp_1626();
        }
        return class_1068.method_4648((UUID)player).comp_1626();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GameProfile fetchPlayerProfile(UUID player) {
        Object object = PLAYER_PROFILE_MAP;
        synchronized (object) {
            GameProfile profile = PLAYER_PROFILE_MAP.get(player);
            if (profile != null) {
                return profile;
            }
        }
        object = FETCH_QUEUE;
        synchronized (object) {
            if (FETCH_QUEUE.add(player)) {
                new Thread(() -> {
                    GameProfile profile;
                    boolean success = false;
                    String name = PlayerRenderer.fetchPlayerName(player);
                    if (name != null && (profile = PlayerRenderer.updateGameProfile(new GameProfile(player, name))) != null) {
                        Map<UUID, GameProfile> map = PLAYER_PROFILE_MAP;
                        synchronized (map) {
                            PLAYER_PROFILE_MAP.put(player, profile);
                        }
                        success = true;
                    }
                    if (!success) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    HashSet<UUID> hashSet = FETCH_QUEUE;
                    synchronized (hashSet) {
                        FETCH_QUEUE.remove(player);
                    }
                }, "Chunk Loaders - Game profile fetching").start();
            }
        }
        return null;
    }

    @Nullable
    private static GameProfile updateGameProfile(@Nullable GameProfile input) {
        MinecraftSessionService sessionService;
        ProfileResult fetchResult;
        if (input != null && input.getId() != null && (fetchResult = (sessionService = PlayerRenderer.getSessionService()).fetchProfile(input.getId(), true)) != null) {
            return fetchResult.profile();
        }
        return null;
    }

    private static String fetchPlayerName(UUID player) {
        try {
            JsonObject json;
            String s;
            InputStream inputStream = new URL("https://api.mojang.com/user/profile/" + String.valueOf(player)).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder builder = new StringBuilder();
            while ((s = reader.readLine()) != null) {
                builder.append(s);
            }
            if (builder.length() > 0 && (json = class_3518.method_15285((String)builder.toString())).has("name")) {
                return json.get("name").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static MinecraftSessionService getSessionService() {
        return ClientUtils.getMinecraft().method_1495();
    }
}

