/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.capability.ChunkLoaderCache;
import com.supermartijn642.chunkloaders.capability.ClientChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.PlayerActivityTracker;
import com.supermartijn642.chunkloaders.capability.ServerChunkLoadingCapability;
import com.supermartijn642.chunkloaders.extensions.ChunkLoadersLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_4844;

public class ChunkLoadingCapability {
    protected final class_1937 level;
    protected final Map<class_1923, Set<UUID>> activePlayersPerLoadedChunk = new HashMap<class_1923, Set<UUID>>();
    protected final Map<class_1923, Set<UUID>> inactivePlayersPerLoadedChunk = new HashMap<class_1923, Set<UUID>>();
    protected final Map<class_1923, Set<class_2338>> chunkLoadersPerChunk = new HashMap<class_1923, Set<class_2338>>();
    protected final Map<UUID, Set<class_1923>> loadedChunksPerPlayer = new HashMap<UUID, Set<class_1923>>();
    protected final Map<UUID, Set<class_1923>> availableChunksPerPlayer = new HashMap<UUID, Set<class_1923>>();
    protected final Map<UUID, Set<class_2338>> chunkLoadersPerPlayer = new HashMap<UUID, Set<class_2338>>();
    protected final Map<class_2338, ChunkLoaderCache> chunkLoaderCacheMap = new HashMap<class_2338, ChunkLoaderCache>();

    public static ChunkLoadingCapability get(class_1937 level) {
        return ((ChunkLoadersLevel)level).getChunkLoadingCapability();
    }

    public ChunkLoadingCapability(class_1937 level) {
        this.level = level;
    }

    public ServerChunkLoadingCapability castServer() {
        return (ServerChunkLoadingCapability)this;
    }

    public ClientChunkLoadingCapability castClient() {
        return (ClientChunkLoadingCapability)this;
    }

    public boolean isChunkLoadedByPlayer(UUID player, class_1923 chunkPos) {
        return this.loadedChunksPerPlayer.containsKey(player) && this.loadedChunksPerPlayer.get(player).contains(chunkPos);
    }

    public boolean isChunkLoaded(class_1923 chunkPos) {
        return this.activePlayersPerLoadedChunk.containsKey(chunkPos) || this.inactivePlayersPerLoadedChunk.containsKey(chunkPos);
    }

    public Set<class_1923> getChunksLoadedByPlayer(UUID player) {
        return Collections.unmodifiableSet(this.loadedChunksPerPlayer.getOrDefault(player, Collections.emptySet()));
    }

    public Set<UUID> getActivePlayersLoadingChunk(class_1923 chunkPos) {
        return Collections.unmodifiableSet(this.activePlayersPerLoadedChunk.getOrDefault(chunkPos, Collections.emptySet()));
    }

    public Set<UUID> getInactivePlayersLoadingChunk(class_1923 chunkPos) {
        return Collections.unmodifiableSet(this.inactivePlayersPerLoadedChunk.getOrDefault(chunkPos, Collections.emptySet()));
    }

    public boolean canPlayerLoadChunk(UUID player, class_1923 chunkPos) {
        int maxLoadedChunks = ChunkLoadersConfig.maxLoadedChunksPerPlayer.get();
        return (maxLoadedChunks <= 0 || !this.loadedChunksPerPlayer.containsKey(player) || this.loadedChunksPerPlayer.get(player).size() < maxLoadedChunks) && this.availableChunksPerPlayer.containsKey(player) && this.availableChunksPerPlayer.get(player).contains(chunkPos);
    }

    public class_2487 write() {
        class_2487 compound = new class_2487();
        class_2499 chunkLoaderCachesTag = new class_2499();
        for (ChunkLoaderCache cache : this.chunkLoaderCacheMap.values()) {
            chunkLoaderCachesTag.add((Object)cache.write());
        }
        compound.method_10566("chunkLoaderCaches", (class_2520)chunkLoaderCachesTag);
        class_2499 loadedChunksPerPlayerTag = new class_2499();
        for (Map.Entry<UUID, Set<class_1923>> entry : this.loadedChunksPerPlayer.entrySet()) {
            class_2487 playerTag = new class_2487();
            playerTag.method_10539("player", class_4844.method_26275((UUID)entry.getKey()));
            playerTag.method_10564("chunks", entry.getValue().stream().mapToLong(class_1923::method_8324).toArray());
            loadedChunksPerPlayerTag.add((Object)playerTag);
        }
        compound.method_10566("loadedChunksPerPlayer", (class_2520)loadedChunksPerPlayerTag);
        return compound;
    }

    public void read(class_2487 compound) {
        class_2499 chunkLoaderCachesTag = compound.method_68569("chunkLoaderCaches");
        chunkLoaderCachesTag.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).map(ChunkLoaderCache::read).forEach(cache -> {
            this.chunkLoaderCacheMap.put(cache.chunkLoaderPos, (ChunkLoaderCache)cache);
            this.chunkLoadersPerChunk.putIfAbsent(cache.chunkPos, new HashSet());
            this.chunkLoadersPerChunk.get(cache.chunkPos).add(cache.chunkLoaderPos);
            this.chunkLoadersPerPlayer.putIfAbsent(cache.owner, new HashSet());
            this.chunkLoadersPerPlayer.get(cache.owner).add(cache.chunkLoaderPos);
            int range = cache.chunkLoaderType.getRange();
            this.availableChunksPerPlayer.putIfAbsent(cache.owner, new HashSet());
            for (int x = -range + 1; x < range; ++x) {
                for (int z = -range + 1; z < range; ++z) {
                    this.availableChunksPerPlayer.get(cache.owner).add(new class_1923(cache.chunkPos.field_9181 + x, cache.chunkPos.field_9180 + z));
                }
            }
        });
        class_2499 loadedChunksPerPlayerTag = compound.method_68569("loadedChunksPerPlayer");
        loadedChunksPerPlayerTag.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).forEach(playerTag -> {
            UUID player = class_4844.method_26276((int[])((int[])playerTag.method_10561("player").get()));
            List<class_1923> chunks = Arrays.stream(playerTag.method_10565("chunks").orElseGet(() -> new long[0])).mapToObj(class_1923::new).toList();
            this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
            this.loadedChunksPerPlayer.get(player).addAll(chunks);
            for (class_1923 chunk : chunks) {
                if (PlayerActivityTracker.isPlayerActive(player)) {
                    this.activePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                    this.activePlayersPerLoadedChunk.get(chunk).add(player);
                    continue;
                }
                this.inactivePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                this.inactivePlayersPerLoadedChunk.get(chunk).add(player);
            }
        });
    }
}

