/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingEventHandler;
import com.supermartijn642.chunkloaders.capability.PlayerActivityTracker;
import com.supermartijn642.chunkloaders.capability.ServerChunkLoadingCapability;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersAtlasSourceGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersBlockStateGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersItemInfoGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersLanguageGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersLootTableGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersModelGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersRecipeGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersTagGenerator;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderAdded;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderRemoved;
import com.supermartijn642.chunkloaders.packet.PackedStartLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedStopLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedTogglePlayerActivity;
import com.supermartijn642.chunkloaders.packet.PacketFullCapabilityData;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3230;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkLoaders
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"chunkloaders");
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"chunkloaders");
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"chunkloaders", ChunkLoaderType.ADVANCED::getItem);

    public void onInitialize() {
        CHANNEL.registerMessage(PackedChunkLoaderAdded.class, PackedChunkLoaderAdded::new, true);
        CHANNEL.registerMessage(PackedChunkLoaderRemoved.class, PackedChunkLoaderRemoved::new, true);
        CHANNEL.registerMessage(PackedStartLoadingChunk.class, PackedStartLoadingChunk::new, true);
        CHANNEL.registerMessage(PackedStopLoadingChunk.class, PackedStopLoadingChunk::new, true);
        CHANNEL.registerMessage(PackedTogglePlayerActivity.class, PackedTogglePlayerActivity::new, true);
        CHANNEL.registerMessage(PacketFullCapabilityData.class, PacketFullCapabilityData::new, true);
        CHANNEL.registerMessage(PacketToggleChunk.class, PacketToggleChunk::new, true);
        ChunkLoadingEventHandler.registerCallbacks();
        PlayerActivityTracker.registerCallbacks();
        ServerBlockEntityEvents.BLOCK_ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof ChunkLoaderBlockEntity) {
                ((ChunkLoaderBlockEntity)entity).onLoad();
            }
        });
        ChunkLoaders.register();
        ChunkLoaders.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"chunkloaders");
        for (ChunkLoaderType type : ChunkLoaderType.values()) {
            handler.registerBlockCallback(type::registerBlock);
            handler.registerBlockEntityTypeCallback(type::registerBlockEntity);
            handler.registerItemCallback(type::registerItem);
        }
        ServerChunkLoadingCapability.CHUNK_LOADING_TICKET_TYPE = (class_3230)class_2378.method_10230((class_2378)class_7923.field_55881, (class_2960)class_2960.method_60655((String)"chunkloaders", (String)"loaded"), (Object)new class_3230(0L, false, class_3230.class_10558.field_55603));
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"chunkloaders");
        handler.addGenerator(ChunkLoadersModelGenerator::new);
        handler.addGenerator(ChunkLoadersAtlasSourceGenerator::new);
        handler.addGenerator(ChunkLoadersBlockStateGenerator::new);
        handler.addGenerator(ChunkLoadersItemInfoGenerator::new);
        handler.addGenerator(ChunkLoadersLanguageGenerator::new);
        handler.addGenerator(ChunkLoadersLootTableGenerator::new);
        handler.addGenerator(ChunkLoadersRecipeGenerator::new);
        handler.addGenerator(ChunkLoadersTagGenerator::new);
    }
}

