/*
 * Decompiled with CFR 0.152.
 */
package jeb.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class FavoritesManager {
    private static final Path FAVORITES_PATH = Paths.get(class_310.method_1551().field_1697.getAbsolutePath(), "config", "JEBfavorites.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Set<class_2960> loadFavoriteItemIds() {
        HashSet<class_2960> result = new HashSet<class_2960>();
        try {
            if (!Files.exists(FAVORITES_PATH, new LinkOption[0])) {
                return result;
            }
            JsonArray array = (JsonArray)GSON.fromJson((Reader)Files.newBufferedReader(FAVORITES_PATH), JsonArray.class);
            String server = FavoritesManager.getServerName();
            for (JsonElement el : array) {
                JsonObject obj = el.getAsJsonObject();
                if (!server.equals(obj.get("server").getAsString())) continue;
                result.add(class_2960.method_60654((String)obj.get("item").getAsString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void removeFavorite(class_1799 stack) {
        try {
            String server = FavoritesManager.getServerName();
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            String nbtString = FavoritesManager.getSerializedNbt(stack);
            if (!Files.exists(FAVORITES_PATH, new LinkOption[0])) {
                return;
            }
            JsonArray favorites = (JsonArray)GSON.fromJson((Reader)Files.newBufferedReader(FAVORITES_PATH), JsonArray.class);
            JsonArray newFavorites = new JsonArray();
            boolean removed = false;
            for (JsonElement element : favorites) {
                JsonObject obj = element.getAsJsonObject();
                boolean sameServer = server.equals(obj.get("server").getAsString());
                boolean sameItem = itemId.toString().equals(obj.get("item").getAsString());
                String nbtInFile = obj.has("nbt") ? obj.get("nbt").getAsString() : "";
                boolean sameNbt = nbtString.equals(nbtInFile);
                if (sameServer && sameItem && sameNbt && !removed) {
                    removed = true;
                    continue;
                }
                newFavorites.add((JsonElement)obj);
            }
            Files.createDirectories(FAVORITES_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(FAVORITES_PATH.toFile());){
                GSON.toJson((JsonElement)newFavorites, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveFavorite(class_1799 stack) {
        block9: {
            try {
                String server = FavoritesManager.getServerName();
                class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
                String nbtString = FavoritesManager.getSerializedNbt(stack);
                JsonArray favorites = Files.exists(FAVORITES_PATH, new LinkOption[0]) ? (JsonArray)GSON.fromJson((Reader)Files.newBufferedReader(FAVORITES_PATH), JsonArray.class) : new JsonArray();
                boolean alreadyExists = false;
                for (JsonElement element : favorites) {
                    JsonObject obj = element.getAsJsonObject();
                    boolean sameServer = server.equals(obj.get("server").getAsString());
                    boolean sameItem = itemId.toString().equals(obj.get("item").getAsString());
                    String nbtInFile = obj.has("nbt") ? obj.get("nbt").getAsString() : "";
                    boolean sameNbt = nbtString.equals(nbtInFile);
                    if (!sameItem || !sameServer || !sameNbt) continue;
                    alreadyExists = true;
                    break;
                }
                if (alreadyExists) break block9;
                JsonObject favoriteEntry = new JsonObject();
                favoriteEntry.addProperty("server", server);
                favoriteEntry.addProperty("item", itemId.toString());
                if (!nbtString.isEmpty()) {
                    favoriteEntry.addProperty("nbt", nbtString);
                }
                favorites.add((JsonElement)favoriteEntry);
                favorites = FavoritesManager.sortFavorites(favorites);
                Files.createDirectories(FAVORITES_PATH.getParent(), new FileAttribute[0]);
                try (FileWriter writer = new FileWriter(FAVORITES_PATH.toFile());){
                    GSON.toJson((JsonElement)favorites, (Appendable)writer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static JsonArray sortFavorites(JsonArray favorites) {
        List<JsonObject> sortedList = favorites.asList().stream().map(JsonElement::getAsJsonObject).sorted(Comparator.comparing(o -> o.get("server").getAsString()).thenComparing(o -> o.get("item").getAsString())).toList();
        JsonArray sortedArray = new JsonArray();
        for (JsonObject obj : sortedList) {
            sortedArray.add((JsonElement)obj);
        }
        return sortedArray;
    }

    private static String getServerName() {
        class_310 client = class_310.method_1551();
        if (client.method_1558() != null) {
            return client.method_1558().field_3761;
        }
        if (client.method_1576() != null) {
            return client.method_1576().method_27728().method_150();
        }
        return "unknown_local_world";
    }

    private static String getSerializedNbt(class_1799 stack) {
        class_9279 entityData;
        class_2561 customData;
        class_2487 result = new class_2487();
        class_9279 blockEntityData = (class_9279)stack.method_58694(class_9334.field_49611);
        if (blockEntityData != null && !blockEntityData.method_57461().method_33133()) {
            result.method_10543(blockEntityData.method_57461());
        }
        if ((customData = (class_2561)stack.method_58694(class_9334.field_49631)) != null && !customData.getString().isEmpty()) {
            return customData.getString();
        }
        class_9279 bucketEntityData = (class_9279)stack.method_58694(class_9334.field_49610);
        if (bucketEntityData != null && !bucketEntityData.method_57461().method_33133()) {
            result.method_10543(bucketEntityData.method_57461());
        }
        if ((entityData = (class_9279)stack.method_58694(class_9334.field_49609)) != null && !entityData.method_57461().method_33133()) {
            result.method_10543(entityData.method_57461());
        }
        return "";
    }
}

