/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.theme;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mojang.brigadier.Message;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_7654;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.addon.core.ModNameProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.TextElement;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.JadeClientCodecs;
import snownee.jade.util.KeyedReloadListener;

public class ThemeHelper
extends class_4309<JadeClientCodecs.ThemeHolder>
implements IThemeHelper,
KeyedReloadListener {
    public static final ThemeHelper INSTANCE = new ThemeHelper();
    public static final class_2960 ID = JadeIds.JADE("themes");
    public static final MutableObject<Theme> theme = new MutableObject();
    private static final Int2ObjectMap<class_2583> styleCache = new Int2ObjectOpenHashMap(6);
    private final Map<class_2960, Theme> themes = Maps.newTreeMap();
    private final class_2096.class_2100 allowedVersions = class_2096.class_2100.method_35287((int)200, (int)299);
    private final class_2583[] modNameStyleCache = new class_2583[3];
    private Theme fallback;

    public ThemeHelper() {
        super(RecordCodecBuilder.create(i -> i.group((App)class_5699.field_33441.fieldOf("version").forGetter(JadeClientCodecs.ThemeHolder::version), (App)Codec.BOOL.optionalFieldOf("autoEnable", (Object)false).forGetter(JadeClientCodecs.ThemeHolder::autoEnable), (App)JadeClientCodecs.THEME.forGetter(JadeClientCodecs.ThemeHolder::theme)).apply((Applicative)i, JadeClientCodecs.ThemeHolder::new)), class_7654.method_45114((String)"jade_themes"));
    }

    public static class_2583 colorStyle(int color) {
        return (class_2583)styleCache.computeIfAbsent(color, arg_0 -> ((class_2583)class_2583.field_24360).method_36139(arg_0));
    }

    @Override
    public Theme theme() {
        return (Theme)theme.getValue();
    }

    @Override
    public Collection<Theme> getThemes() {
        return this.themes.values();
    }

    @Override
    @NotNull
    public Theme getTheme(class_2960 id) {
        return (Theme)Preconditions.checkNotNull((Object)this.themes.getOrDefault(id, this.fallback), (String)"Theme not found: %s", (Object)id);
    }

    @Override
    public boolean hasTheme(class_2960 id) {
        return this.themes.containsKey(id);
    }

    @Override
    public class_5250 info(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().info());
    }

    @Override
    public class_5250 success(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().success());
    }

    @Override
    public class_5250 warning(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().warning());
    }

    @Override
    public class_5250 danger(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().danger());
    }

    @Override
    public class_5250 failure(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().failure());
    }

    @Override
    public class_5250 title(Object componentOrString) {
        class_5250 component = componentOrString instanceof class_5250 ? (class_5250)componentOrString : class_2561.method_43470((String)Objects.toString(componentOrString));
        return this.color(DisplayHelper.INSTANCE.stripColor((class_2561)component), this.theme().text.colors().title());
    }

    @Override
    public TextElement modName(Object componentOrString) {
        class_5250 component = componentOrString instanceof class_5250 ? (class_5250)componentOrString : class_2561.method_43470((String)Objects.toString(componentOrString));
        class_2583 itemStyle = IWailaConfig.get().formatting().getItemModNameStyle();
        class_2583 themeStyle = this.theme().text.modNameStyle();
        if (this.modNameStyleCache[0] != itemStyle || this.modNameStyleCache[1] != themeStyle) {
            class_2583 style = itemStyle;
            if (themeStyle != null) {
                style = themeStyle.method_27702(style);
            }
            this.modNameStyleCache[0] = itemStyle;
            this.modNameStyleCache[1] = themeStyle;
            this.modNameStyleCache[2] = style;
        }
        return JadeUI.text((class_2561)component.method_27696(this.modNameStyleCache[2])).scale(Objects.equals(IWailaConfig.get().plugin().getEnum(JadeIds.CORE_MOD_NAME), (Object)ModNameProvider.Mode.SMALLER) ? 0.75f : 1.0f);
    }

    @Override
    public class_5250 seconds(int ticks, float tickRate) {
        if ((ticks = class_3532.method_15375((float)((float)ticks / tickRate))) >= 60) {
            int minutes = ticks / 60;
            if ((ticks %= 60) == 0) {
                return this.info(JadeClient.format("jade.minutes", minutes));
            }
            return this.info(JadeClient.format("jade.minutes_seconds", minutes, ticks));
        }
        return this.info(JadeClient.format("jade.seconds", ticks));
    }

    protected class_5250 color(Object componentOrString, int color) {
        class_5250 component;
        if (componentOrString instanceof Number) {
            Number number = (Number)componentOrString;
            componentOrString = DisplayHelper.dfCommas.format(number.doubleValue());
        }
        if (componentOrString instanceof class_5250) {
            component = (class_5250)componentOrString;
            if (component.method_10866().method_10967()) {
                return component.method_10862(ThemeHelper.colorStyle(color));
            }
            return component.method_10862(component.method_10866().method_36139(color));
        }
        if (componentOrString instanceof class_2561) {
            component = (class_2561)componentOrString;
            if (component.method_10866().method_10967()) {
                return component.method_27661().method_10862(ThemeHelper.colorStyle(color));
            }
            return component.method_27661().method_10862(component.method_10866().method_36139(color));
        }
        if (componentOrString instanceof Message) {
            Message message = (Message)componentOrString;
            return class_2561.method_43470((String)message.getString()).method_10862(ThemeHelper.colorStyle(color));
        }
        return class_2561.method_43470((String)Objects.toString(componentOrString)).method_10862(ThemeHelper.colorStyle(color));
    }

    protected void apply(Map<class_2960, JadeClientCodecs.ThemeHolder> map, class_3300 resourceManager, class_3695 profilerFiller) {
        Set<class_2960> existingKeys = Set.copyOf(this.themes.keySet());
        MutableObject enable = new MutableObject();
        WailaConfig.Overlay config = Jade.config().overlay();
        WailaConfig.History history = Jade.history();
        this.themes.clear();
        map.forEach((id, holder) -> {
            if (!this.allowedVersions.method_9054(holder.version())) {
                Jade.LOGGER.warn("Theme {} has unsupported version {}. Skipping.", id, (Object)holder.version());
                return;
            }
            Theme theme = holder.theme();
            theme.id = id;
            this.themes.put((class_2960)id, theme);
            if (enable.getValue() == null && holder.autoEnable() && !existingKeys.contains(id)) {
                enable.setValue((Object)theme);
            }
        });
        this.fallback = this.themes.get(JadeIds.DEFAULT_THEME);
        if (this.fallback == null) {
            class_128 crashreport = class_128.method_560((Throwable)new NullPointerException(), (String)"Missing default theme");
            throw new class_148(crashreport);
        }
        int hash = 0;
        for (class_2960 id2 : this.themes.keySet()) {
            hash = 31 * hash + id2.hashCode();
        }
        if (hash != history.themesHash) {
            if (hash != 0 && enable.getValue() != null) {
                Theme theme = (Theme)enable.getValue();
                config.activeTheme = theme.id;
                Jade.LOGGER.info("Auto enabled theme {}", (Object)theme.id);
                if (theme.changeOpacity != 0.0f) {
                    config.setAlpha(theme.changeOpacity);
                }
            }
            history.themesHash = hash;
            IWailaConfig.get().save();
        }
        config.applyTheme(config.activeTheme);
        theme.setValue((Object)config.getTheme());
    }

    @Override
    public class_2960 getUid() {
        return ID;
    }
}

