/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.MessageType;
import snownee.jade.api.ui.ProgressStyle;

public class ProgressView {
    public List<Part> parts = List.of();
    public final ProgressStyle style;
    public final BoxStyle boxStyle;
    @Nullable
    public class_2561 text;

    public ProgressView(ProgressStyle style, BoxStyle boxStyle) {
        this.style = Objects.requireNonNull(style);
        this.boxStyle = Objects.requireNonNull(boxStyle);
    }

    public ProgressView(Part progress, @Nullable class_2561 text, ProgressStyle style, BoxStyle boxStyle) {
        this(List.of(progress), text, style, boxStyle);
    }

    public ProgressView(List<Part> progress, @Nullable class_2561 text, ProgressStyle style, BoxStyle boxStyle) {
        this(style, boxStyle);
        this.parts = Objects.requireNonNull(progress);
        this.text = text;
    }

    public static ProgressView read(Data data) {
        ProgressView view = new ProgressView(JadeUI.progressStyle(), BoxStyle.nestedBox());
        if (data.progress > 0.0f) {
            view.parts = List.of(Part.of(data.progress, data.messageType));
        }
        return view;
    }

    public record Data(float progress, MessageType messageType) {
        public static final class_9139<ByteBuf, Data> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48552, Data::progress, MessageType.STREAM_CODEC, Data::messageType, Data::new);

        public Data(float progress) {
            this(progress, MessageType.NORMAL);
        }
    }

    public record Part(float progress, @Nullable Element overlay, @Nullable MessageType messageType, int color) {
        public Part(float progress, @Nullable Element overlay, @Nullable MessageType messageType, int color) {
            this.progress = progress;
            this.overlay = overlay;
            this.messageType = messageType;
            this.color = color;
            Preconditions.checkArgument((progress >= 0.0f && progress <= 1.0f ? 1 : 0) != 0, (String)"Progress must be between 0 and 1, got: %s", (Object)Float.valueOf(progress));
        }

        public static Part of(float progress) {
            return Part.of(progress, MessageType.NORMAL);
        }

        public static Part of(float progress, MessageType messageType) {
            return new Part(progress, null, messageType, -1);
        }

        public static Part of(float progress, Element overlay) {
            return new Part(progress, overlay, null, -1);
        }

        public static Part of(float progress, int color) {
            return new Part(progress, null, null, color);
        }

        public int themeColor() {
            if (this.color != -1) {
                return this.color;
            }
            if (this.messageType != null) {
                return IThemeHelper.get().theme().progressColors.get(this.messageType);
            }
            return -1;
        }
    }
}

