/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.theme;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8658;
import net.minecraft.class_8690;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.SneakyDetails;
import snownee.jade.api.theme.TextSetting;
import snownee.jade.api.ui.BoxElement;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.ColorPalette;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.ui.BoxElementImpl;

public class Theme {
    public class_2960 id;
    public String styleName;
    public BoxStyle tooltipStyle;
    public BoxStyle nestedBoxStyle;
    public BoxStyle viewGroupStyle;
    public TextSetting text;
    public float changeOpacity;
    public boolean lightColorScheme;
    public class_2960 iconSlotSprite;
    public int iconSlotInflation;
    public BoxElement iconSlotSpriteCache;
    public SneakyDetails sneakyDetails;
    public ColorPalette progressColors;
    public Map<class_2960, class_2960> spriteMapping;

    public Theme(String styleName, BoxStyle tooltipStyle, BoxStyle nestedBoxStyle, BoxStyle viewGroupStyle, TextSetting text, float changeOpacity, boolean lightColorScheme, Optional<class_2960> iconSlotSprite, int iconSlotInflation, SneakyDetails sneakyDetails, ColorPalette progressColors, Map<class_2960, class_2960> spriteMapping) {
        this.styleName = styleName;
        this.tooltipStyle = tooltipStyle;
        this.nestedBoxStyle = nestedBoxStyle;
        this.viewGroupStyle = viewGroupStyle;
        this.text = text;
        this.changeOpacity = changeOpacity;
        this.lightColorScheme = lightColorScheme;
        this.iconSlotSprite = iconSlotSprite.orElse(null);
        this.iconSlotInflation = iconSlotInflation;
        this.sneakyDetails = sneakyDetails;
        this.progressColors = progressColors;
        this.spriteMapping = spriteMapping;
    }

    public class_2960 mainId() {
        if (this.id.method_12832().contains("/")) {
            return this.id.method_45136(this.id.method_12832().substring(0, this.id.method_12832().indexOf(47)));
        }
        return this.id;
    }

    public String styleId() {
        if (this.id.method_12832().contains("/")) {
            return this.id.method_12832().substring(this.id.method_12832().indexOf(47) + 1);
        }
        return "";
    }

    public class_2960 mapSprite(class_2960 sprite) {
        return this.spriteMapping.getOrDefault(sprite, sprite);
    }

    @Nullable
    public Element modifyIcon(@Nullable Element icon) {
        if (icon == null) {
            return null;
        }
        IWailaConfig.Overlay overlay = IWailaConfig.get().overlay();
        if (!overlay.shouldShowIcon() || overlay.getIconMode() == IWailaConfig.IconMode.INLINE) {
            return null;
        }
        if (this.iconSlotSprite != null) {
            if (this.iconSlotSpriteCache == null) {
                class_8658 guiSprites = class_310.method_1551().method_52699();
                class_1058 textureAtlasSprite = guiSprites.method_18667(this.iconSlotSprite);
                class_8690 scaling = guiSprites.method_52714(textureAtlasSprite);
                int[] padding = new int[4];
                Arrays.fill(padding, this.iconSlotInflation);
                if (scaling instanceof class_8690.class_8691) {
                    class_8690.class_8691 nineSlice = (class_8690.class_8691)scaling;
                    class_8690.class_8691.class_8692 border = nineSlice.comp_1639();
                    padding[0] = padding[0] + border.comp_1641();
                    padding[1] = padding[1] + border.comp_1642();
                    padding[2] = padding[2] + border.comp_1643();
                    padding[3] = padding[3] + border.comp_1640();
                }
                this.iconSlotSpriteCache = new BoxElementImpl(new Tooltip(), BoxStyle.tooltip(this.iconSlotSprite, padding));
            }
            Tooltip tooltip1 = this.iconSlotSpriteCache.getTooltip();
            tooltip1.clear();
            tooltip1.add(icon);
            icon = this.iconSlotSpriteCache;
        }
        return icon.tag(JadeIds.CORE_ROOT_ICON);
    }
}

