/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.jade.JadeClient;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.NarratableComponent;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public class FluidStorageProvider<T extends Accessor<?>>
implements StreamServerDataProvider<T, Map.Entry<class_2960, List<ViewGroup<FluidView.Data>>>> {
    private static final class_9139<class_9129, Map.Entry<class_2960, List<ViewGroup<FluidView.Data>>>> STREAM_CODEC = ViewGroup.listCodec(FluidView.Data.STREAM_CODEC);
    public static final FluidStorageProvider<BlockAccessor> BLOCK = new FluidStorageProvider();
    public static final FluidStorageProvider<EntityAccessor> ENTITY = new FluidStorageProvider();

    @Override
    public class_2960 getUid() {
        return JadeIds.UNIVERSAL_FLUID_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    @Nullable
    public Map.Entry<class_2960, List<ViewGroup<FluidView.Data>>> streamData(T accessor) {
        return CommonProxy.getServerExtensionData(accessor, WailaCommonRegistration.instance().fluidStorageProviders);
    }

    @Override
    public class_9139<class_9129, Map.Entry<class_2960, List<ViewGroup<FluidView.Data>>>> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        if (!accessor.showDetails() && IWailaConfig.get().plugin().get(JadeIds.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
            return false;
        }
        return WailaCommonRegistration.instance().fluidStorageProviders.hitsAny((Accessor<?>)accessor, (BiPredicate<IServerExtensionProvider<FluidView.Data>, Accessor<?>>)((BiPredicate<IServerExtensionProvider, Accessor>)IServerExtensionProvider::shouldRequestData));
    }

    public static class Extension
    implements IServerExtensionProvider<FluidView.Data>,
    IClientExtensionProvider<FluidView.Data, FluidView> {
        public static final Extension INSTANCE = new Extension();

        @Override
        public class_2960 getUid() {
            return JadeIds.UNIVERSAL_FLUID_STORAGE_DEFAULT;
        }

        @Override
        public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<FluidView.Data>> groups) {
            return ClientViewGroup.map(groups, FluidView::readDefault, null);
        }

        @Override
        @Nullable
        public List<ViewGroup<FluidView.Data>> getGroups(Accessor<?> accessor) {
            return CommonProxy.wrapFluidStorage(accessor);
        }

        @Override
        public boolean shouldRequestData(Accessor<?> accessor) {
            return CommonProxy.hasDefaultFluidStorage(accessor);
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }
    }

    public static class Client<T extends Accessor<?>>
    extends FluidStorageProvider<T>
    implements IComponentProvider<T> {
        public static final Client<BlockAccessor> BLOCK = new Client();
        public static final Client<EntityAccessor> ENTITY = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
            if (!accessor.showDetails() && config.get(JadeIds.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
                return;
            }
            List groups = ClientProxy.mapToClientGroups(accessor, JadeIds.UNIVERSAL_FLUID_STORAGE, STREAM_CODEC, WailaClientRegistration.instance().fluidStorageProviders::get, tooltip);
            if (groups == null || groups.isEmpty()) {
                return;
            }
            boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
            ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
                int extra;
                if (renderGroup) {
                    group.renderHeader((ITooltip)theTooltip);
                }
                for (FluidView view : group.views) {
                    class_2561 text;
                    IWailaConfig.HandlerDisplayStyle style = (IWailaConfig.HandlerDisplayStyle)config.getEnum(JadeIds.UNIVERSAL_FLUID_STORAGE_STYLE);
                    if (view.overrideText != null) {
                        text = view.overrideText;
                    } else if (view.fluidName == null) {
                        text = NarratableComponent.attach((class_2561)IThemeHelper.get().info(view.current), view.current);
                    } else {
                        class_5250 fluidName = IThemeHelper.get().info(IDisplayHelper.get().stripColor(view.fluidName));
                        class_2561 fluidAmount = accessor.showDetails() || style != IWailaConfig.HandlerDisplayStyle.PROGRESS_BAR ? new NarratableComponent((class_2561)class_2561.method_43469((String)"jade.fluid.with_capacity", (Object[])new Object[]{IThemeHelper.get().info(view.current), view.max}), () -> JadeClient.formatString("narration.jade.withCapacity", NarratableComponent.getNarration((class_5348)view.current), NarratableComponent.getNarration((class_5348)view.max))) : NarratableComponent.attach((class_2561)IThemeHelper.get().info(view.current), view.current);
                        String key = style == IWailaConfig.HandlerDisplayStyle.PLAIN_TEXT ? "jade.fluid.text" : "jade.fluid";
                        text = NarratableComponent.translatable(key, fluidName, fluidAmount);
                    }
                    switch (style) {
                        case PLAIN_TEXT: {
                            theTooltip.add(text);
                            break;
                        }
                        case ICON: {
                            theTooltip.add(JadeUI.smallItem(new class_1799((class_1935)class_1802.field_8550)));
                            theTooltip.append(text);
                            break;
                        }
                        case PROGRESS_BAR: {
                            ProgressView progressView = new ProgressView(ProgressView.Part.of(view.ratio, view.overlay), text, JadeUI.progressStyle(), BoxStyle.nestedBox());
                            theTooltip.add(JadeUI.progress(progressView));
                        }
                    }
                }
                if (group.extraData != null && (extra = group.extraData.method_68083("+", 0)) > 0) {
                    theTooltip.add((class_2561)class_2561.method_43469((String)"jade.fluid.more_tanks", (Object[])new Object[]{extra}));
                }
            });
        }
    }
}

