/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public final class CreativeItemGroup
extends class_1761 {
    private final String modid;
    private final String identifier;
    private Consumer<Consumer<class_1799>> filler;
    private Comparator<class_1799> sorter;
    private List<class_1799> sortedDisplayItems;

    public static CreativeItemGroup create(String modid, String name, Supplier<class_1799> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Item group name '" + name + "' must only contain characters [a-z0-9_.-]!");
        }
        String translationKey = modid + ".item_group." + name;
        return new CreativeItemGroup(modid, name, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, String name, class_1935 icon) {
        return CreativeItemGroup.create(modid, name, () -> icon.method_8389().method_7854());
    }

    public static CreativeItemGroup create(String modid, Supplier<class_1799> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String translationKey = modid + ".item_group";
        return new CreativeItemGroup(modid, modid, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, class_1935 icon) {
        return CreativeItemGroup.create(modid, () -> icon.method_8389().method_7854());
    }

    public static class_1761 getBuildingBlocks() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_40195).orElseThrow()).comp_349();
    }

    public static class_1761 getColoredBlocks() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_41059).orElseThrow()).comp_349();
    }

    public static class_1761 getNaturalBlocks() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_40743).orElseThrow()).comp_349();
    }

    public static class_1761 getFunctionalBlocks() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_40197).orElseThrow()).comp_349();
    }

    public static class_1761 getRedstoneBlocks() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_40198).orElseThrow()).comp_349();
    }

    public static class_1761 getToolsAndUtilities() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_41060).orElseThrow()).comp_349();
    }

    public static class_1761 getCombat() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_40202).orElseThrow()).comp_349();
    }

    public static class_1761 getFoodAndDrinks() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_41061).orElseThrow()).comp_349();
    }

    public static class_1761 getIngredients() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_41062).orElseThrow()).comp_349();
    }

    public static class_1761 getSpawnEggs() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_40205).orElseThrow()).comp_349();
    }

    public static class_1761 getOperatorUtilities() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_41063).orElseThrow()).comp_349();
    }

    public static class_1761 getSearch() {
        return (class_1761)((class_6880.class_6883)class_7923.field_44687.method_46746(class_7706.field_40200).orElseThrow()).comp_349();
    }

    private CreativeItemGroup(String modid, String identifier, String translationKey, Supplier<class_1799> icon) {
        super(class_1761.class_7915.field_41049, 0, class_1761.class_7916.field_41052, (class_2561)TextComponents.translation(translationKey).get(), icon, (a, b) -> {});
        this.modid = modid;
        this.identifier = identifier;
        this.field_41037 = (flags, output) -> this.applyFiller(arg_0 -> ((class_1761.class_7704)output).method_45420(arg_0));
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)class_2960.method_60655((String)modid, (String)identifier), (Object)((Object)this));
    }

    private void applyFiller(Consumer<class_1799> output) {
        if (this.filler != null) {
            this.filler.accept(output);
        }
    }

    public CreativeItemGroup filler(Consumer<Consumer<class_1799>> filler) {
        this.filler = filler;
        return this;
    }

    public CreativeItemGroup sorter(Comparator<class_1799> sorter) {
        this.sorter = sorter;
        return this;
    }

    public CreativeItemGroup sortAlphabetically() {
        return this.sorter(Comparator.comparing(stack -> TextComponents.itemStack(stack).format()));
    }

    public void method_47306(class_1761.class_8128 parameters) {
        super.method_47306(parameters);
        if (this.sorter != null) {
            this.sortedDisplayItems = new ArrayList<class_1799>(this.field_40859);
            this.sortedDisplayItems.sort(this.sorter);
        }
    }

    public Collection<class_1799> method_47313() {
        return this.sortedDisplayItems == null ? super.method_47313() : this.sortedDisplayItems;
    }
}

