/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.extensions.GuiGraphicsExtension;
import com.supermartijn642.core.gui.ArbitraryPictureInPictureRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11245;
import net.minecraft.class_11247;
import net.minecraft.class_11256;
import net.minecraft.class_11540;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7999;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8030;
import net.minecraft.class_811;
import net.minecraft.class_8689;
import net.minecraft.class_8690;
import net.minecraft.class_9848;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public final class GuiGraphicsHelper {
    public static final class_2960 SCREEN_BACKGROUND_SPRITE = class_2960.method_60655((String)"supermartijn642corelib", (String)"gui/background");
    public static final class_2960 BUTTON_DEFAULT_SPRITE = class_2960.method_60655((String)"supermartijn642corelib", (String)"gui/button_default");
    public static final class_2960 BUTTON_HIGHLIGHTED_SPRITE = class_2960.method_60655((String)"supermartijn642corelib", (String)"gui/button_highlighted");
    public static final class_2960 BUTTON_DISABLED_SPRITE = class_2960.method_60655((String)"supermartijn642corelib", (String)"gui/button_disabled");
    public static final class_2960 SLOT_SPRITE = class_2960.method_60655((String)"supermartijn642corelib", (String)"gui/slot");
    private final class_332 guiGraphics;
    private TextProperties textProperties;
    private TextureProperties textureProperties;
    private RectangleProperties rectangleProperties;
    private TooltipContent tooltipContent;
    private TooltipProperties tooltipProperties;
    private ItemProperties itemProperties;

    public static GuiGraphicsHelper of(class_332 guiGraphics) {
        GuiGraphicsHelper helper = ((GuiGraphicsExtension)guiGraphics).supermartijn642corelibGetHelper();
        if (helper == null) {
            helper = new GuiGraphicsHelper(guiGraphics);
            ((GuiGraphicsExtension)guiGraphics).supermartijn642corelibSetHelper(helper);
        }
        return helper;
    }

    private GuiGraphicsHelper(class_332 guiGraphics) {
        this.guiGraphics = guiGraphics;
    }

    public Matrix3x2fStack poseStack() {
        return this.guiGraphics.method_51448();
    }

    public void pushScissor(float x, float y, int width, int height) {
        this.guiGraphics.method_44379((int)x, (int)y, (int)(x + (float)width), (int)(y + (float)height));
    }

    public void popScissor() {
        this.guiGraphics.method_44380();
    }

    public void nextStratum() {
        this.guiGraphics.method_71048();
    }

    public boolean isPointInScissor(float x, float y) {
        return this.guiGraphics.method_58135((int)x, (int)y);
    }

    public void submitText(class_5348 text, float x, float y, Consumer<TextProperties> properties) {
        class_327 font;
        if (this.textProperties == null) {
            this.textProperties = new TextProperties();
        } else {
            this.textProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.textProperties);
        }
        class_327 class_3272 = font = this.textProperties.font == null ? ClientUtils.getFontRenderer() : this.textProperties.font;
        if (this.textProperties.wrapWidth != null) {
            List lines = font.method_1728(text, this.textProperties.wrapWidth.intValue());
            if (this.textProperties.centerHorizontally) {
                int widestLine = 0;
                for (class_5481 line : lines) {
                    int width = font.method_30880(line);
                    if (width <= widestLine) continue;
                    widestLine = width;
                }
                x -= (float)widestLine / 2.0f;
            }
            if (this.textProperties.centerVertically) {
                int n = lines.size();
                Objects.requireNonNull(font);
                y -= (float)(n * 9) / 2.0f;
            }
            Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)this.guiGraphics.method_51448());
            class_8030 scissor = this.guiGraphics.field_44659.method_70863();
            for (class_5481 line : lines) {
                this.guiGraphics.field_59826.method_70921(new class_11247(font, line, pose, (int)x, (int)y, this.textProperties.color, this.textProperties.backgroundColor, this.textProperties.shadow, scissor));
            }
            return;
        }
        if (this.textProperties.cutoffWidth != null) {
            int cutoff = this.textProperties.cutoffWidth;
            if (this.textProperties.cutoffPostfix != null) {
                cutoff -= font.method_27525((class_5348)this.textProperties.cutoffPostfix);
            }
            if (cutoff >= 0) {
                text = font.method_1714(text, cutoff);
                if (this.textProperties.cutoffPostfix != null) {
                    text = class_5348.method_29433((class_5348[])new class_5348[]{text, this.textProperties.cutoffPostfix});
                }
            } else {
                text = font.method_1714((class_5348)this.textProperties.cutoffPostfix, this.textProperties.cutoffWidth.intValue());
            }
        }
        if (this.textProperties.centerHorizontally) {
            x -= (float)font.method_27525(text) / 2.0f;
        }
        if (this.textProperties.centerVertically) {
            Objects.requireNonNull(font);
            y -= 9.0f / 2.0f;
        }
        this.guiGraphics.field_59826.method_70921(new class_11247(font, class_2477.method_10517().method_30934(text), new Matrix3x2f((Matrix3x2fc)this.guiGraphics.method_51448()), (int)x, (int)y, this.textProperties.color, this.textProperties.backgroundColor, this.textProperties.shadow, this.guiGraphics.field_44659.method_70863()));
    }

    public void submitText(class_5348 text, float x, float y) {
        this.submitText(text, x, y, null);
    }

    public void submitText(String text, float x, float y, Consumer<TextProperties> properties) {
        this.submitText((class_5348)class_2561.method_43470((String)text), x, y, properties);
    }

    public void submitText(String text, float x, float y) {
        this.submitText((class_5348)class_2561.method_43470((String)text), x, y, null);
    }

    public void submitTexture(GpuTextureView texture, float x, float y, float width, float height, Consumer<TextureProperties> properties) {
        if (this.textureProperties == null) {
            this.textureProperties = new TextureProperties();
        } else {
            this.textureProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.textureProperties);
        }
        if (this.textureProperties.centerHorizontally) {
            x -= width / 2.0f;
        }
        if (this.textureProperties.centerVertically) {
            y -= height / 2.0f;
        }
        this.guiGraphics.method_70847(this.textureProperties.renderPipeline, texture, (int)x, (int)y, (int)(x + width), (int)(y + height), this.textureProperties.u, this.textureProperties.u + this.textureProperties.w, this.textureProperties.v, this.textureProperties.v + this.textureProperties.h, this.textureProperties.color);
    }

    public void submitTexture(GpuTextureView texture, float x, float y, float width, float height) {
        this.submitTexture(texture, x, y, width, height, null);
    }

    public void submitTexture(class_2960 texture, float x, float y, float width, float height, Consumer<TextureProperties> properties) {
        GpuTextureView textureView = this.guiGraphics.field_44656.method_1531().method_4619(texture).method_71659();
        this.submitTexture(textureView, x, y, width, height, properties);
    }

    public void submitTexture(class_2960 texture, float x, float y, float width, float height) {
        this.submitTexture(texture, x, y, width, height, null);
    }

    public void submitSprite(class_1058 sprite, float x, float y, float width, float height, Consumer<TextureProperties> properties) {
        class_8690 scaling = sprite.method_45851().method_52848().method_43041(class_8689.field_45647).orElse(class_8689.field_45645).comp_1636();
        if (scaling instanceof class_8690.class_8693 || !sprite.method_45852().equals((Object)this.guiGraphics.field_45337.field_18230.method_24106())) {
            if (properties == null) {
                properties = p -> {};
            }
            this.submitTexture(sprite.method_45852(), x, y, width, height, properties.andThen(p -> {
                float u = sprite.method_4580(p.u);
                float v = sprite.method_4570(p.v);
                p.uv(u, v, sprite.method_4580(p.u + p.w) - u, sprite.method_4570(p.v + p.h) - v);
            }));
            return;
        }
        if (this.textureProperties == null) {
            this.textureProperties = new TextureProperties();
        } else {
            this.textureProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.textureProperties);
        }
        if (this.textureProperties.centerHorizontally) {
            x -= width / 2.0f;
        }
        if (this.textureProperties.centerVertically) {
            y -= height / 2.0f;
        }
        this.guiGraphics.method_52707(this.textureProperties.renderPipeline, sprite.method_45851().method_45816(), (int)x, (int)y, (int)width, (int)height, this.textureProperties.color);
    }

    public void submitSprite(class_1058 sprite, float x, float y, float width, float height) {
        this.submitSprite(sprite, x, y, width, height, null);
    }

    public void submitSprite(class_2960 sprite, float x, float y, float width, float height, Consumer<TextureProperties> properties) {
        this.submitSprite(this.guiGraphics.field_45337.method_18667(sprite), x, y, width, height, properties);
    }

    public void submitSprite(class_2960 sprite, float x, float y, float width, float height) {
        this.submitSprite(sprite, x, y, width, height, null);
    }

    public void submitDefaultScreenBackground(float x, float y, float width, float height) {
        this.submitSprite(SCREEN_BACKGROUND_SPRITE, x, y, width, height, null);
    }

    public void submitDefaultButton(ButtonState state, float x, float y, float width, float height) {
        this.submitSprite(switch (state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BUTTON_DEFAULT_SPRITE;
            case 2 -> BUTTON_DISABLED_SPRITE;
            case 1 -> BUTTON_HIGHLIGHTED_SPRITE;
        }, x, y, width, height, null);
    }

    public void submitDefaultSlot(float x, float y, float width, float height) {
        this.submitSprite(SLOT_SPRITE, x, y, width, height, null);
    }

    public void submitDefaultSlot(float x, float y) {
        this.submitDefaultSlot(x, y, 18.0f, 18.0f);
    }

    public void submitRectangle(float x, float y, float width, float height, Consumer<RectangleProperties> properties) {
        if (this.rectangleProperties == null) {
            this.rectangleProperties = new RectangleProperties();
        } else {
            this.rectangleProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.rectangleProperties);
        }
        if (this.rectangleProperties.centerHorizontally) {
            x -= width / 2.0f;
        }
        if (this.rectangleProperties.centerVertically) {
            y -= height / 2.0f;
        }
        if (this.rectangleProperties.border != -1) {
            int border = this.rectangleProperties.border;
            int color = this.rectangleProperties.beginColor;
            RenderPipeline renderPipeline = this.rectangleProperties.renderPipeline;
            this.guiGraphics.method_48196(renderPipeline, (int)x, (int)y, (int)(x + width), (int)y + border, color);
            this.guiGraphics.method_48196(renderPipeline, (int)x, (int)y - border, (int)(x + width), (int)y, color);
            this.guiGraphics.method_48196(renderPipeline, (int)x, (int)y + border, (int)x + border, (int)(y + height) - border, color);
            this.guiGraphics.method_48196(renderPipeline, (int)x - border, (int)y + border, (int)x, (int)(y + height) - border, color);
            return;
        }
        this.guiGraphics.method_70848(this.rectangleProperties.renderPipeline, class_11231.method_70899(), (int)x, (int)y, (int)(x + width), (int)(y + height), this.rectangleProperties.beginColor, Integer.valueOf(this.rectangleProperties.endColor));
    }

    void submitRectangle(float x, float y, float width, float height) {
        this.submitRectangle(x, y, width, height, null);
    }

    public void submitTooltip(Consumer<TooltipContent> content, float x, float y, Consumer<TooltipProperties> properties) {
        if (this.tooltipContent == null) {
            this.tooltipContent = new TooltipContent();
        } else {
            this.tooltipContent.clear();
        }
        content.accept(this.tooltipContent);
        if (this.tooltipContent.content.isEmpty()) {
            return;
        }
        if (this.tooltipProperties == null) {
            this.tooltipProperties = new TooltipProperties();
        } else {
            this.tooltipProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.tooltipProperties);
        }
        this.guiGraphics.method_51435(this.tooltipProperties.font == null ? ClientUtils.getFontRenderer() : this.tooltipProperties.font, List.copyOf(this.tooltipContent.content), (int)x, (int)y, this.tooltipProperties.positioner, this.tooltipProperties.frame);
    }

    public void submitTooltip(Consumer<TooltipContent> content, float x, float y) {
        this.submitTooltip(content, x, y, null);
    }

    public void submitTooltipForTopStratum(Consumer<TooltipContent> content, float x, float y, Consumer<TooltipProperties> properties) {
        if (this.tooltipContent == null) {
            this.tooltipContent = new TooltipContent();
        } else {
            this.tooltipContent.clear();
        }
        content.accept(this.tooltipContent);
        if (this.tooltipContent.content.isEmpty()) {
            return;
        }
        if (this.tooltipProperties == null) {
            this.tooltipProperties = new TooltipProperties();
        } else {
            this.tooltipProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.tooltipProperties);
        }
        Matrix3x2f matrix = new Matrix3x2f((Matrix3x2fc)this.guiGraphics.method_51448());
        class_327 font = this.tooltipProperties.font == null ? ClientUtils.getFontRenderer() : this.tooltipProperties.font;
        List<class_5684> components = List.copyOf(this.tooltipContent.content);
        class_8000 positioner = this.tooltipProperties.positioner;
        class_2960 frame = this.tooltipProperties.frame;
        this.guiGraphics.field_60305 = () -> {
            this.guiGraphics.method_51448().pushMatrix().set((Matrix3x2fc)matrix);
            this.guiGraphics.method_51435(font, components, (int)x, (int)y, positioner, frame);
            this.guiGraphics.method_51448().popMatrix();
        };
    }

    public void submitTooltipForTopStratum(Consumer<TooltipContent> content, float x, float y) {
        this.submitTooltipForTopStratum(content, x, y, null);
    }

    public void submitItem(class_1799 item, float x, float y, Consumer<ItemProperties> properties) {
        if (item.method_7960()) {
            return;
        }
        if (this.itemProperties == null) {
            this.itemProperties = new ItemProperties();
        } else {
            this.itemProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.itemProperties);
        }
        class_11540 renderState = new class_11540();
        if (!this.itemProperties.allowOversized) {
            renderState.method_72172(false);
        }
        ClientUtils.getMinecraft().method_65386().method_65598((class_10444)renderState, item, this.itemProperties.displayContext, this.itemProperties.level, this.itemProperties.entity, 0);
        this.guiGraphics.field_59826.method_70920(new class_11245(item.method_7909().method_63680().toString(), new Matrix3x2f((Matrix3x2fc)this.guiGraphics.method_51448()), renderState, (int)x, (int)y, this.guiGraphics.field_44659.method_70863()));
        if (this.itemProperties.showBar) {
            this.guiGraphics.method_64860(item, (int)x, (int)y);
        }
        if (this.itemProperties.showCooldown) {
            this.guiGraphics.method_64861(item, (int)x, (int)y);
        }
        if (this.itemProperties.showCount) {
            this.guiGraphics.method_64859(ClientUtils.getFontRenderer(), item, (int)x, (int)y, null);
        }
    }

    public void submitItem(class_1799 item, float x, float y) {
        this.submitItem(item, x, y, null);
    }

    public void submitGuiElement(class_11244 element) {
        this.guiGraphics.field_59826.method_70919(element);
    }

    public void submitPictureInPicture(class_11256 element) {
        this.guiGraphics.field_59826.method_70922(element);
    }

    public void submitCustomRendering(int x, int y, int width, int height, Consumer<class_4587> rendering) {
        this.guiGraphics.field_59826.method_70922((class_11256)new ArbitraryPictureInPictureRenderer.State(x, y, width, height, new Matrix3x2f((Matrix3x2fc)this.guiGraphics.method_51448()), rendering));
    }

    public static final class TextProperties {
        private class_327 font;
        private int color;
        private int backgroundColor;
        private boolean shadow;
        private boolean centerHorizontally;
        private boolean centerVertically;
        private Integer wrapWidth;
        private Integer cutoffWidth;
        private class_2561 cutoffPostfix;

        private TextProperties() {
            this.clear();
        }

        private void clear() {
            this.defaultFont();
            this.defaultColor();
            this.noBackground();
            this.shadow(false);
            this.centerHorizontally(false);
            this.centerVertically(false);
            this.wrapWidth = null;
            this.cutoffWidth = null;
            this.cutoffPostfix = null;
        }

        public TextProperties font(class_327 font) {
            this.font = font;
            return this;
        }

        public TextProperties defaultFont() {
            return this.font(null);
        }

        public TextProperties color(int color) {
            this.color = color | 0xFF000000;
            return this;
        }

        public TextProperties color(int red, int green, int blue) {
            return this.color(class_9848.method_61323((int)red, (int)green, (int)blue));
        }

        public TextProperties color(int red, int green, int blue, int alpha) {
            return this.color(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
        }

        public TextProperties defaultColor() {
            return this.color(0x404040);
        }

        public TextProperties activeColor() {
            return this.color(0xE0E0E0);
        }

        public TextProperties inactiveColor() {
            return this.color(0x707070);
        }

        public TextProperties backgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public TextProperties noBackground() {
            return this.backgroundColor(0);
        }

        public TextProperties shadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        public TextProperties shadow() {
            return this.shadow(true);
        }

        public TextProperties centerHorizontally(boolean center) {
            this.centerHorizontally = center;
            return this;
        }

        public TextProperties centerHorizontally() {
            return this.centerHorizontally(true);
        }

        public TextProperties centerVertically(boolean center) {
            this.centerVertically = center;
            return this;
        }

        public TextProperties centerVertically() {
            return this.centerVertically(true);
        }

        public TextProperties center() {
            this.centerHorizontally();
            return this.centerVertically();
        }

        public TextProperties wrap(int maxWidth) {
            if (maxWidth < 0) {
                maxWidth = 0;
            }
            this.wrapWidth = maxWidth;
            this.cutoffWidth = null;
            this.cutoffPostfix = null;
            return this;
        }

        public TextProperties cutoff(int maxWidth, class_2561 postfix) {
            if (maxWidth < 0) {
                maxWidth = 0;
            }
            this.cutoffWidth = maxWidth;
            this.cutoffPostfix = postfix;
            this.wrapWidth = null;
            return this;
        }

        public TextProperties cutoff(int maxWidth) {
            return this.cutoff(maxWidth, null);
        }

        public TextProperties cutoffWithDots(int maxWidth) {
            return this.cutoff(maxWidth, (class_2561)class_2561.method_43470((String)"..."));
        }
    }

    public static final class TextureProperties {
        private RenderPipeline renderPipeline;
        private float u;
        private float v;
        private float w;
        private float h;
        private int color;
        private boolean centerHorizontally;
        private boolean centerVertically;

        private TextureProperties() {
            this.clear();
        }

        private void clear() {
            this.defaultPipeline();
            this.fullUV();
            this.color(-1);
            this.centerHorizontally(false);
            this.centerVertically(false);
        }

        public TextureProperties renderPipeline(RenderPipeline renderPipeline) {
            this.renderPipeline = renderPipeline;
            return this;
        }

        public TextureProperties defaultPipeline() {
            return this.renderPipeline(class_10799.field_56883);
        }

        public TextureProperties uv(float u, float v, float width, float height) {
            this.u = u;
            this.v = v;
            this.w = width;
            this.h = height;
            return this;
        }

        public TextureProperties fullUV() {
            return this.uv(0.0f, 0.0f, 1.0f, 1.0f);
        }

        public TextureProperties color(int color) {
            this.color = color;
            return this;
        }

        public TextureProperties color(int red, int green, int blue) {
            return this.color(class_9848.method_61323((int)red, (int)green, (int)blue));
        }

        public TextureProperties color(int red, int green, int blue, int alpha) {
            return this.color(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
        }

        public TextureProperties centerHorizontally(boolean center) {
            this.centerHorizontally = center;
            return this;
        }

        public TextureProperties centerHorizontally() {
            return this.centerHorizontally(true);
        }

        public TextureProperties centerVertically(boolean center) {
            this.centerVertically = center;
            return this;
        }

        public TextureProperties centerVertically() {
            return this.centerVertically(true);
        }

        public TextureProperties center() {
            this.centerHorizontally();
            return this.centerVertically();
        }
    }

    public static enum ButtonState {
        DEFAULT,
        HIGHLIGHTED,
        DISABLED;

    }

    public static final class RectangleProperties {
        private RenderPipeline renderPipeline;
        private int beginColor;
        private int endColor;
        private boolean centerHorizontally;
        private boolean centerVertically;
        private int border;

        private RectangleProperties() {
            this.clear();
        }

        private void clear() {
            this.defaultPipeline();
            this.color(-1);
            this.centerHorizontally(false);
            this.centerVertically(false);
            this.border = -1;
        }

        public RectangleProperties renderPipeline(RenderPipeline renderPipeline) {
            this.renderPipeline = renderPipeline;
            return this;
        }

        public RectangleProperties defaultPipeline() {
            return this.renderPipeline(class_10799.field_56879);
        }

        public RectangleProperties color(int beginColor, int endColor) {
            this.beginColor = beginColor;
            this.endColor = endColor;
            return this;
        }

        public RectangleProperties color(int color) {
            return this.color(color, color);
        }

        public RectangleProperties color(int red, int green, int blue) {
            return this.color(class_9848.method_61323((int)red, (int)green, (int)blue));
        }

        public RectangleProperties color(int red, int green, int blue, int alpha) {
            return this.color(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
        }

        public RectangleProperties centerHorizontally(boolean center) {
            this.centerHorizontally = center;
            return this;
        }

        public RectangleProperties centerHorizontally() {
            return this.centerHorizontally(true);
        }

        public RectangleProperties centerVertically(boolean center) {
            this.centerVertically = center;
            return this;
        }

        public RectangleProperties centerVertically() {
            return this.centerVertically(true);
        }

        public RectangleProperties center() {
            this.centerHorizontally();
            return this.centerVertically();
        }

        public RectangleProperties unfilled(int borderThickness) {
            this.border = borderThickness;
            return this;
        }
    }

    public static class TooltipContent {
        private final List<class_5684> content = new ArrayList<class_5684>(10);

        private TooltipContent() {
        }

        private void clear() {
            this.content.clear();
        }

        public TooltipContent add(Collection<class_5684> components) {
            this.content.addAll(components);
            return this;
        }

        public TooltipContent add(class_5684 ... components) {
            return this.add(Arrays.asList(components));
        }

        public TooltipContent text(Collection<class_2561> components) {
            this.content.addAll(components.stream().map(c -> class_5684.method_32662((class_5481)c.method_30937())).toList());
            return this;
        }

        public TooltipContent text(class_2561 ... components) {
            return this.text(Arrays.asList(components));
        }

        public TooltipContent literal(Collection<String> s) {
            this.content.addAll(s.stream().map(s2 -> class_5684.method_32662((class_5481)class_5481.method_30747((String)s2, (class_2583)class_2583.field_24360))).toList());
            return this;
        }

        public TooltipContent literal(String ... s) {
            return this.literal(Arrays.asList(s));
        }

        public TooltipContent synced(Collection<class_5632> components) {
            this.content.addAll(components.stream().map(class_5684::method_32663).toList());
            return this;
        }

        public TooltipContent synced(class_5632 ... components) {
            return this.synced(Arrays.asList(components));
        }
    }

    public static class TooltipProperties {
        private class_8000 positioner;
        private class_327 font;
        private class_2960 frame;

        private TooltipProperties() {
            this.clear();
        }

        private void clear() {
            this.defaultPositioner();
            this.defaultFont();
            this.defaultFrame();
        }

        public TooltipProperties positioner(class_8000 positioner) {
            this.positioner = positioner;
            return this;
        }

        public TooltipProperties defaultPositioner() {
            return this.positioner(class_8001.field_41687);
        }

        public TooltipProperties aboveOrBelow(float x, float y, float width, float height) {
            return this.positioner((class_8000)new class_7999(new class_8030((int)x, (int)y, (int)width, (int)height)));
        }

        public TooltipProperties font(class_327 font) {
            this.font = font;
            return this;
        }

        public TooltipProperties defaultFont() {
            return this.font(null);
        }

        public TooltipProperties frame(class_2960 texture) {
            this.frame = texture;
            return this;
        }

        public TooltipProperties defaultFrame() {
            return this.frame(null);
        }
    }

    public static final class ItemProperties {
        private class_1937 level;
        private class_1309 entity;
        private boolean allowOversized;
        private boolean showBar;
        private boolean showCount;
        private boolean showCooldown;
        private class_811 displayContext;

        private ItemProperties() {
            this.clear();
        }

        private void clear() {
            this.level = null;
            this.entity = null;
            this.allowOversized = true;
            this.showBar = true;
            this.showCount = true;
            this.showCooldown = true;
            this.guiDisplayContext();
        }

        public ItemProperties level(class_1937 level) {
            this.level = level;
            return this;
        }

        public ItemProperties entity(class_1309 entity) {
            this.entity = entity;
            return this;
        }

        public ItemProperties allowOversized(boolean allowOversized) {
            this.allowOversized = allowOversized;
            return this;
        }

        public ItemProperties forceNoOversized() {
            return this.allowOversized(false);
        }

        public ItemProperties showBar(boolean showBar) {
            this.showBar = showBar;
            return this;
        }

        public ItemProperties noBar() {
            return this.showBar(false);
        }

        public ItemProperties showCount(boolean showCount) {
            this.showCount = showCount;
            return this;
        }

        public ItemProperties noCount() {
            return this.showCount(false);
        }

        public ItemProperties showCooldown(boolean showCooldown) {
            this.showCooldown = showCooldown;
            return this;
        }

        public ItemProperties noCooldown() {
            return this.showCooldown(false);
        }

        public ItemProperties noDecorations() {
            this.showBar(false);
            this.showCount(false);
            return this.showCooldown(false);
        }

        public ItemProperties displayContext(class_811 displayContext) {
            this.displayContext = displayContext;
            return this;
        }

        public ItemProperties guiDisplayContext() {
            return this.displayContext(class_811.field_4317);
        }
    }
}

