/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.generator.AdvancementGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_175;
import net.minecraft.class_1761;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9326;

public abstract class RecipeGenerator
extends ResourceGenerator {
    private static final Map<class_5321<class_1761>, class_7800> TAB_TO_CATEGORY = new HashMap<class_5321<class_1761>, class_7800>();
    private final Map<class_2960, RecipeBuilder<?>> recipes = new HashMap();
    private final Advancements advancements;

    public RecipeGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
        this.advancements = new Advancements(modid, cache);
    }

    @Override
    public void save() {
        this.advancements.generate();
        for (RecipeBuilder<?> recipeBuilder : this.recipes.values()) {
            JsonObject json = new JsonObject();
            HashMap<String, JsonObject> subRecipes = new HashMap<String, JsonObject>();
            subRecipes.put("", json);
            json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(recipeBuilder.serializer).toString());
            if (recipeBuilder instanceof ShapedRecipeBuilder) {
                HashSet<Character> characters = new HashSet<Character>();
                for (String string : ((ShapedRecipeBuilder)recipeBuilder).pattern) {
                    for (char c : string.toCharArray()) {
                        if (c == ' ' || !characters.add(Character.valueOf(c)) || ((ShapedRecipeBuilder)recipeBuilder).inputs.containsKey(Character.valueOf(c))) continue;
                        throw new RuntimeException("Recipe '" + String.valueOf(recipeBuilder.identifier) + "' is missing an input for character '" + c + "'!");
                    }
                }
                for (Character c : ((ShapedRecipeBuilder)recipeBuilder).inputs.keySet()) {
                    if (characters.contains(c)) continue;
                    throw new RuntimeException("Recipe '" + String.valueOf(recipeBuilder.identifier) + "' has unused input with key '" + c + "'!");
                }
                json.addProperty("group", recipeBuilder.group);
                json.add("pattern", (JsonElement)RecipeGenerator.createArray(((ShapedRecipeBuilder)recipeBuilder).pattern));
                JsonObject keysJson = new JsonObject();
                for (Map.Entry<Character, RecipeInput> input : ((ShapedRecipeBuilder)recipeBuilder).inputs.entrySet()) {
                    keysJson.add(input.getKey().toString(), RecipeGenerator.serializeInput(input.getValue()));
                }
                json.add("key", (JsonElement)keysJson);
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("id", Registries.ITEMS.getIdentifier(recipeBuilder.output.method_8389()).toString());
                if (recipeBuilder.outputCount != 1) {
                    jsonObject.addProperty("count", (Number)recipeBuilder.outputCount);
                }
                if (recipeBuilder.outputComponents != null && !recipeBuilder.outputComponents.method_57848()) {
                    jsonObject.add("components", (JsonElement)class_9326.field_49589.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipeBuilder.outputComponents).getOrThrow());
                }
                json.add("result", (JsonElement)jsonObject);
            } else if (recipeBuilder instanceof ShapelessRecipeBuilder) {
                json.addProperty("group", recipeBuilder.group);
                JsonArray ingredientsJson = new JsonArray();
                for (RecipeInput recipeInput : ((ShapelessRecipeBuilder)recipeBuilder).inputs) {
                    ingredientsJson.add(RecipeGenerator.serializeInput(recipeInput));
                }
                json.add("ingredients", (JsonElement)ingredientsJson);
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("id", Registries.ITEMS.getIdentifier(recipeBuilder.output.method_8389()).toString());
                if (recipeBuilder.outputCount != 1) {
                    resultJson.addProperty("count", (Number)recipeBuilder.outputCount);
                }
                if (recipeBuilder.outputComponents != null && !recipeBuilder.outputComponents.method_57848()) {
                    resultJson.add("components", (JsonElement)class_9326.field_49589.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipeBuilder.outputComponents).getOrThrow());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof SmeltingRecipeBuilder) {
                JsonObject recipeJson;
                if (((SmeltingRecipeBuilder)recipeBuilder).includeBlasting) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:blasting");
                    RecipeGenerator.serializeCookingRecipe(recipeJson, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_blasting", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmoking) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:smoking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_smoking", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeCampfire) {
                    recipeJson = new JsonObject();
                    recipeJson.addProperty("type", "minecraft:campfire_cooking");
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 2, 100);
                    subRecipes.put("_campfire", recipeJson);
                }
                if (((SmeltingRecipeBuilder)recipeBuilder).includeSmelting) {
                    RecipeGenerator.serializeCookingRecipe(json, (SmeltingRecipeBuilder)recipeBuilder, 1, 200);
                } else {
                    subRecipes.remove("");
                }
            } else if (recipeBuilder instanceof SmithingRecipeBuilder) {
                json.addProperty("group", recipeBuilder.group);
                json.add("base", RecipeGenerator.serializeInput(((SmithingRecipeBuilder)recipeBuilder).base));
                json.add("addition", RecipeGenerator.serializeInput(((SmithingRecipeBuilder)recipeBuilder).addition));
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("id", Registries.ITEMS.getIdentifier(recipeBuilder.output.method_8389()).toString());
                if (recipeBuilder.outputCount != 1) {
                    resultJson.addProperty("count", (Number)recipeBuilder.outputCount);
                }
                if (recipeBuilder.outputComponents != null && !recipeBuilder.outputComponents.method_57848()) {
                    resultJson.add("components", (JsonElement)class_9326.field_49589.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipeBuilder.outputComponents).getOrThrow());
                }
                json.add("result", (JsonElement)resultJson);
            } else if (recipeBuilder instanceof StoneCuttingRecipeBuilder) {
                json.addProperty("group", recipeBuilder.group);
                json.add("ingredient", RecipeGenerator.serializeInput(((StoneCuttingRecipeBuilder)recipeBuilder).input));
                json.addProperty("result", Registries.ITEMS.getIdentifier(recipeBuilder.output.method_8389()).toString());
                json.addProperty("count", (Number)recipeBuilder.outputCount);
            }
            for (Map.Entry subRecipe : subRecipes.entrySet()) {
                json = (JsonObject)subRecipe.getValue();
                if (!recipeBuilder.conditions.isEmpty()) {
                    json = ConditionalRecipeSerializer.wrapRecipe(json, recipeBuilder.conditions);
                }
                class_2960 class_29602 = recipeBuilder.identifier;
                this.cache.saveJsonResource(ResourceType.DATA, json, class_29602.method_12836(), "recipe", class_29602.method_12832() + (String)subRecipe.getKey());
            }
        }
        this.advancements.save();
    }

    private static void serializeCookingRecipe(JsonObject json, SmeltingRecipeBuilder recipeBuilder, int durationDivider, int defaultDuration) {
        int duration;
        json.addProperty("group", recipeBuilder.group);
        json.add("ingredient", RecipeGenerator.serializeInput(recipeBuilder.input));
        if ((recipeBuilder.outputComponents == null || recipeBuilder.outputComponents.method_57848()) && recipeBuilder.outputCount == 1) {
            json.addProperty("result", Registries.ITEMS.getIdentifier(recipeBuilder.output.method_8389()).toString());
        } else {
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("id", Registries.ITEMS.getIdentifier(recipeBuilder.output.method_8389()).toString());
            if (recipeBuilder.outputCount != 1) {
                resultJson.addProperty("count", (Number)recipeBuilder.outputCount);
            }
            if (recipeBuilder.outputComponents != null && !recipeBuilder.outputComponents.method_57848()) {
                resultJson.add("components", (JsonElement)class_9326.field_49589.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipeBuilder.outputComponents).getOrThrow());
            }
            json.add("result", (JsonElement)resultJson);
        }
        if (recipeBuilder.experience != 0) {
            json.addProperty("experience", (Number)recipeBuilder.experience);
        }
        if ((duration = recipeBuilder.duration / durationDivider) != defaultDuration) {
            json.addProperty("cookingtime", (Number)duration);
        }
    }

    private static JsonArray createArray(Iterable<String> elements) {
        JsonArray array = new JsonArray();
        for (String element : elements) {
            array.add(element);
        }
        return array;
    }

    private static JsonElement serializeInput(RecipeInput input) {
        if (input.entries.size() == 1) {
            return RecipeGenerator.serializeInputEntry(input.entries.getFirst());
        }
        JsonArray entries = new JsonArray();
        for (RecipeInput.Entry entry : input.entries) {
            entries.add(RecipeGenerator.serializeInputEntry(entry));
        }
        return entries;
    }

    private static JsonElement serializeInputEntry(RecipeInput.Entry entry) {
        if (entry.item != null) {
            return new JsonPrimitive(Registries.ITEMS.getIdentifier(entry.item.method_8389()).toString());
        }
        return new JsonPrimitive("#" + entry.tag.toString());
    }

    protected <T extends RecipeBuilder<T>> T recipe(class_2960 recipeLocation, T builder) {
        if (this.recipes.containsKey(recipeLocation)) {
            throw new RuntimeException("Duplicate recipe '" + String.valueOf(recipeLocation) + "' of types '" + this.recipes.get(recipeLocation).getClass().getName() + "' and '" + builder.getClass().getName() + "'!");
        }
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, builder.identifier.method_12836(), "recipe", builder.identifier.method_12832(), ".json");
        this.recipes.put(recipeLocation, builder);
        return builder;
    }

    protected ShapedRecipeBuilder shaped(class_2960 recipeLocation, class_1935 output, class_9326 components, int amount) {
        return this.recipe(recipeLocation, new ShapedRecipeBuilder(recipeLocation, output, components, amount));
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, class_1935 output, class_9326 components, int amount) {
        return this.shaped(class_2960.method_60655((String)namespace, (String)identifier), output, components, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, class_1935 output, class_9326 components, int amount) {
        return this.shaped(this.modid, identifier, output, components, amount);
    }

    protected ShapedRecipeBuilder shaped(class_1935 output, class_9326 components, int amount) {
        class_2960 identifier = Registries.ITEMS.getIdentifier(output.method_8389());
        return this.recipe(identifier, new ShapedRecipeBuilder(identifier, output, components, amount));
    }

    protected ShapedRecipeBuilder shaped(class_2960 recipeLocation, class_1935 output, int amount) {
        return this.shaped(recipeLocation, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, class_1935 output, int amount) {
        return this.shaped(class_2960.method_60655((String)namespace, (String)identifier), output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(String identifier, class_1935 output, int amount) {
        return this.shaped(this.modid, identifier, output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(class_1935 output, int amount) {
        return this.shaped(output, null, amount);
    }

    protected ShapedRecipeBuilder shaped(class_2960 recipeLocation, class_1935 output) {
        return this.shaped(recipeLocation, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, class_1935 output) {
        return this.shaped(class_2960.method_60655((String)namespace, (String)identifier), output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(String identifier, class_1935 output) {
        return this.shaped(this.modid, identifier, output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(class_1935 output) {
        return this.shaped(output, null, 1);
    }

    protected ShapedRecipeBuilder shaped(class_2960 recipeLocation, class_1799 output) {
        return this.shaped(recipeLocation, (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected ShapedRecipeBuilder shaped(String namespace, String identifier, class_1799 output) {
        return this.shaped(class_2960.method_60655((String)namespace, (String)identifier), (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected ShapedRecipeBuilder shaped(String identifier, class_1799 output) {
        return this.shaped(this.modid, identifier, (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected ShapedRecipeBuilder shaped(class_1799 output) {
        return this.shaped((class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected ShapelessRecipeBuilder shapeless(class_2960 recipeLocation, class_1935 output, class_9326 components, int amount) {
        return this.recipe(recipeLocation, new ShapelessRecipeBuilder(recipeLocation, output, components, amount));
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, class_1935 output, class_9326 components, int amount) {
        return this.shapeless(class_2960.method_60655((String)namespace, (String)identifier), output, components, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, class_1935 output, class_9326 components, int amount) {
        return this.shapeless(this.modid, identifier, output, components, amount);
    }

    protected ShapelessRecipeBuilder shapeless(class_1935 output, class_9326 components, int amount) {
        class_2960 identifier = Registries.ITEMS.getIdentifier(output.method_8389());
        return this.shapeless(identifier, output, components, amount);
    }

    protected ShapelessRecipeBuilder shapeless(class_2960 recipeLocation, class_1935 output, int amount) {
        return this.shapeless(recipeLocation, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, class_1935 output, int amount) {
        return this.shapeless(class_2960.method_60655((String)namespace, (String)identifier), output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, class_1935 output, int amount) {
        return this.shapeless(this.modid, identifier, output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(class_1935 output, int amount) {
        return this.shapeless(output, null, amount);
    }

    protected ShapelessRecipeBuilder shapeless(class_2960 recipeLocation, class_1935 output) {
        return this.shapeless(recipeLocation, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, class_1935 output) {
        return this.shapeless(class_2960.method_60655((String)namespace, (String)identifier), output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, class_1935 output) {
        return this.shapeless(this.modid, identifier, output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(class_1935 output) {
        return this.shapeless(output, null, 1);
    }

    protected ShapelessRecipeBuilder shapeless(class_2960 recipeLocation, class_1799 output) {
        return this.shapeless(recipeLocation, (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected ShapelessRecipeBuilder shapeless(String namespace, String identifier, class_1799 output) {
        return this.shapeless(class_2960.method_60655((String)namespace, (String)identifier), (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected ShapelessRecipeBuilder shapeless(String identifier, class_1799 output) {
        return this.shapeless(this.modid, identifier, (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected ShapelessRecipeBuilder shapeless(class_1799 output) {
        return this.shapeless((class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected SmeltingRecipeBuilder smelting(class_2960 recipeLocation, class_1935 output, class_9326 components, int amount) {
        return this.recipe(recipeLocation, new SmeltingRecipeBuilder(recipeLocation, output, components, amount)).includeSmelting();
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, class_1935 output, class_9326 components, int amount) {
        return this.smelting(class_2960.method_60655((String)namespace, (String)identifier), output, components, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, class_1935 output, class_9326 components, int amount) {
        return this.smelting(this.modid, identifier, output, components, amount);
    }

    protected SmeltingRecipeBuilder smelting(class_1935 output, class_9326 components, int amount) {
        class_2960 identifier = Registries.ITEMS.getIdentifier(output.method_8389());
        return this.smelting(identifier, output, components, amount);
    }

    protected SmeltingRecipeBuilder smelting(class_2960 recipeLocation, class_1935 output, int amount) {
        return this.smelting(recipeLocation, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, class_1935 output, int amount) {
        return this.smelting(class_2960.method_60655((String)namespace, (String)identifier), output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, class_1935 output, int amount) {
        return this.smelting(this.modid, identifier, output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(class_1935 output, int amount) {
        return this.smelting(output, null, amount);
    }

    protected SmeltingRecipeBuilder smelting(class_2960 recipeLocation, class_1935 output) {
        return this.smelting(recipeLocation, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, class_1935 output) {
        return this.smelting(class_2960.method_60655((String)namespace, (String)identifier), output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(String identifier, class_1935 output) {
        return this.smelting(this.modid, identifier, output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(class_1935 output) {
        return this.smelting(output, null, 1);
    }

    protected SmeltingRecipeBuilder smelting(class_2960 recipeLocation, class_1799 output) {
        return this.smelting(recipeLocation, (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected SmeltingRecipeBuilder smelting(String namespace, String identifier, class_1799 output) {
        return this.smelting(class_2960.method_60655((String)namespace, (String)identifier), (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected SmeltingRecipeBuilder smelting(String identifier, class_1799 output) {
        return this.smelting(this.modid, identifier, (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected SmeltingRecipeBuilder smelting(class_1799 output) {
        return this.smelting((class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected SmithingRecipeBuilder smithing(class_2960 recipeLocation, class_1935 output, class_9326 components, int amount) {
        return this.recipe(recipeLocation, new SmithingRecipeBuilder(recipeLocation, output, components, amount));
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, class_1935 output, class_9326 components, int amount) {
        return this.smithing(class_2960.method_60655((String)namespace, (String)identifier), output, components, amount);
    }

    protected SmithingRecipeBuilder smithing(String identifier, class_1935 output, class_9326 components, int amount) {
        return this.smithing(this.modid, identifier, output, components, amount);
    }

    protected SmithingRecipeBuilder smithing(class_1935 output, class_9326 components, int amount) {
        class_2960 identifier = Registries.ITEMS.getIdentifier(output.method_8389());
        return this.smithing(identifier, output, components, amount);
    }

    protected SmithingRecipeBuilder smithing(class_2960 recipeLocation, class_1935 output, int amount) {
        return this.smithing(recipeLocation, output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, class_1935 output, int amount) {
        return this.smithing(class_2960.method_60655((String)namespace, (String)identifier), output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(String identifier, class_1935 output, int amount) {
        return this.smithing(this.modid, identifier, output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(class_1935 output, int amount) {
        return this.smithing(output, null, amount);
    }

    protected SmithingRecipeBuilder smithing(class_2960 recipeLocation, class_1935 output) {
        return this.smithing(recipeLocation, output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, class_1935 output) {
        return this.smithing(class_2960.method_60655((String)namespace, (String)identifier), output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(String identifier, class_1935 output) {
        return this.smithing(this.modid, identifier, output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(class_1935 output) {
        return this.smithing(output, null, 1);
    }

    protected SmithingRecipeBuilder smithing(class_2960 recipeLocation, class_1799 output) {
        return this.smithing(recipeLocation, (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected SmithingRecipeBuilder smithing(String namespace, String identifier, class_1799 output) {
        return this.smithing(class_2960.method_60655((String)namespace, (String)identifier), (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected SmithingRecipeBuilder smithing(String identifier, class_1799 output) {
        return this.smithing(this.modid, identifier, (class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected SmithingRecipeBuilder smithing(class_1799 output) {
        return this.smithing((class_1935)output.method_7909(), output.method_57380(), output.method_7947());
    }

    protected StoneCuttingRecipeBuilder stoneCutting(class_2960 recipeLocation, class_1935 output, int amount) {
        return this.recipe(recipeLocation, new StoneCuttingRecipeBuilder(recipeLocation, output, amount));
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, class_1935 output, int amount) {
        return this.stoneCutting(class_2960.method_60655((String)namespace, (String)identifier), output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, class_1935 output, int amount) {
        return this.stoneCutting(this.modid, identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(class_1935 output, int amount) {
        class_2960 identifier = Registries.ITEMS.getIdentifier(output.method_8389());
        return this.stoneCutting(identifier, output, amount);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(class_2960 recipeLocation, class_1935 output) {
        return this.stoneCutting(recipeLocation, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String namespace, String identifier, class_1935 output) {
        return this.stoneCutting(class_2960.method_60655((String)namespace, (String)identifier), output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(String identifier, class_1935 output) {
        return this.stoneCutting(this.modid, identifier, output, 1);
    }

    protected StoneCuttingRecipeBuilder stoneCutting(class_1935 output) {
        return this.stoneCutting(output, 1);
    }

    @Override
    public String getName() {
        return this.modName + " Recipe Generator";
    }

    static {
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_40195, class_7800.field_40634);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_40202, class_7800.field_40639);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_41059, class_7800.field_40634);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_41061, class_7800.field_40640);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_40197, class_7800.field_40634);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_41062, class_7800.field_40642);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_40743, class_7800.field_40635);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_40198, class_7800.field_40636);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_41063, class_7800.field_40642);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_40205, class_7800.field_40642);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_41060, class_7800.field_40638);
        TAB_TO_CATEGORY.put((class_5321<class_1761>)class_7706.field_40200, class_7800.field_40642);
    }

    private final class Advancements
    extends AdvancementGenerator {
        public Advancements(String modid, ResourceCache cache) {
            super(modid, cache);
        }

        @Override
        public void generate() {
            for (RecipeBuilder<?> recipe : RecipeGenerator.this.recipes.values()) {
                if (!recipe.hasAdvancement) continue;
                class_1792 outputItem = recipe.output.method_8389();
                String category = class_7800.field_40642.method_46203();
                for (class_1761 tab : class_7706.method_47341()) {
                    class_5321 key;
                    if (!tab.method_45412(outputItem.method_7854()) || (key = (class_5321)class_7923.field_44687.method_29113((Object)tab).orElse(null)) == null) continue;
                    category = TAB_TO_CATEGORY.containsKey(key) ? TAB_TO_CATEGORY.get(key).method_46203() : key.method_29177().method_12832();
                }
                String namespace = recipe.identifier.method_12836();
                String identifier = "recipes/" + category + "/" + recipe.identifier.method_12832();
                if (recipe instanceof SmeltingRecipeBuilder) {
                    if (((SmeltingRecipeBuilder)recipe).includeSmelting) {
                        this.createAdvancement(namespace, identifier + "_smelting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeBlasting) {
                        this.createAdvancement(namespace, identifier + "_blasting", recipe);
                    }
                    if (((SmeltingRecipeBuilder)recipe).includeSmoking) {
                        this.createAdvancement(namespace, identifier + "_smoking", recipe);
                    }
                    if (!((SmeltingRecipeBuilder)recipe).includeCampfire) continue;
                    this.createAdvancement(namespace, identifier + "_campfire", recipe);
                    continue;
                }
                this.createAdvancement(namespace, identifier, recipe);
            }
        }

        private void createAdvancement(String namespace, String identifier, RecipeBuilder<?> recipe) {
            AdvancementGenerator.AdvancementBuilder builder = this.advancement(namespace, identifier).parent(class_2960.method_60655((String)"minecraft", (String)"recipes/root")).criterion("has_the_recipe", class_2119.method_27847((class_5321)class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)recipe.identifier))).icon(recipe.output, recipe.outputComponents).dontShowToast().dontAnnounceToChat().rewardRecipe(recipe.identifier);
            String[] triggers = new String[recipe.unlockedBy.size() + 1];
            triggers[0] = "has_the_recipe";
            if (recipe.unlockedBy.size() == 1) {
                Pair<class_179<?>, class_184> criterion = recipe.unlockedBy.get(0);
                builder.criterion("recipe_condition", new class_175(criterion.left(), criterion.right()));
                triggers[1] = "recipe_condition";
            } else {
                for (int i = 0; i < recipe.unlockedBy.size(); ++i) {
                    Pair<class_179<?>, class_184> criterion = recipe.unlockedBy.get(i);
                    builder.criterion("recipe_condition" + (i + 1), new class_175(criterion.left(), criterion.right()));
                    triggers[i + 1] = "recipe_condition" + (i + 1);
                }
            }
            builder.requirementGroup(triggers);
            recipe.conditions.forEach(builder::condition);
        }
    }

    public static abstract class RecipeBuilder<T extends RecipeBuilder<T>> {
        protected final class_2960 identifier;
        private final List<ResourceCondition> conditions = new ArrayList<ResourceCondition>();
        private final class_1935 output;
        private final class_9326 outputComponents;
        private final int outputCount;
        private class_1865<?> serializer;
        private String group;
        private boolean hasAdvancement = true;
        private final List<Pair<class_179<?>, class_184>> unlockedBy = new ArrayList();

        protected RecipeBuilder(class_2960 identifier, class_1865<?> serializer, class_1935 output, class_9326 outputComponents, int outputCount) {
            this.identifier = identifier;
            this.output = output;
            this.outputComponents = outputComponents;
            this.outputCount = outputCount;
            this.serializer = serializer;
        }

        public T group(String group) {
            this.group = group == null || group.trim().isEmpty() ? null : group;
            return this.self();
        }

        public T condition(ResourceCondition condition) {
            this.conditions.add(condition);
            return this.self();
        }

        public T notCondition(ResourceCondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public T modLoadedCondition(String modid) {
            return this.condition(new ModLoadedResourceCondition(modid));
        }

        public T advancement(boolean generate) {
            this.hasAdvancement = generate;
            return this.self();
        }

        public T noAdvancement() {
            return this.advancement(false);
        }

        public <S extends class_184> T unlockedBy(class_179<S> trigger, S instance) {
            this.unlockedBy.add(Pair.of(trigger, instance));
            return this.self();
        }

        public <S extends class_184> T unlockedBy(class_175<S> criterion) {
            return this.unlockedBy(criterion.comp_1923(), criterion.comp_1924());
        }

        public T unlockedBy(class_1935 ... items) {
            return this.unlockedBy(class_2066.class_2068.method_8959((class_1935[])items));
        }

        public T unlockedBy(class_6862<class_1792> tagKey) {
            return this.unlockedBy(class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975((class_7871)ResourceGenerator.registryAccess.method_46762(class_7924.field_41197), tagKey).method_8976()}));
        }

        public T customSerializer(class_1865<?> serializer) {
            this.serializer = serializer;
            return this.self();
        }

        private T self() {
            return (T)this;
        }
    }

    protected static class ShapedRecipeBuilder
    extends RecipeBuilder<ShapedRecipeBuilder> {
        private final List<String> pattern = new ArrayList<String>();
        private final Map<Character, RecipeInput> inputs = new HashMap<Character, RecipeInput>();

        private ShapedRecipeBuilder(class_2960 identifier, class_1935 output, class_9326 outputComponents, int outputCount) {
            super(identifier, class_1865.field_9035, output, outputComponents, outputCount);
        }

        public ShapedRecipeBuilder pattern(String row) {
            if (row.isEmpty()) {
                throw new IllegalArgumentException("Pattern row for recipe '" + String.valueOf(this.identifier) + "' cannot be empty!");
            }
            if (row.length() > 3) {
                throw new IllegalArgumentException("Pattern row for recipe '" + String.valueOf(this.identifier) + "' can have at most 3 characters, not '" + row.length() + "'!");
            }
            for (String otherRow : this.pattern) {
                if (row.length() == otherRow.length()) continue;
                throw new IllegalArgumentException("Pattern rows for recipe '" + String.valueOf(this.identifier) + "' must have the same length!");
            }
            this.pattern.add(row);
            return this;
        }

        public ShapedRecipeBuilder pattern(String ... rows) {
            for (String row : rows) {
                this.pattern(row);
            }
            return this;
        }

        private ShapedRecipeBuilder input(char key, RecipeInput input) {
            if (this.inputs.containsKey(Character.valueOf(key))) {
                throw new RuntimeException("Duplicate key '" + key + "' for recipe '" + String.valueOf(this.identifier) + "'!");
            }
            this.inputs.put(Character.valueOf(key), input);
            return this;
        }

        public ShapedRecipeBuilder input(char key, class_1935 ... items) {
            return this.input(key, RecipeInput.of(items));
        }

        public ShapedRecipeBuilder input(char key, class_1799 ... itemStacks) {
            return this.input(key, RecipeInput.of(itemStacks));
        }

        public ShapedRecipeBuilder input(char key, class_6862<class_1792> tag) {
            return this.input(key, RecipeInput.of(tag));
        }
    }

    private record RecipeInput(List<Entry> entries) {
        static RecipeInput of(class_1935 ... items) {
            return new RecipeInput(Arrays.stream(items).map(i -> new Entry((class_1935)i, null)).toList());
        }

        static RecipeInput of(class_1799 ... stacks) {
            return RecipeInput.of((class_1935[])Arrays.stream(stacks).map(class_1799::method_7909).toArray(class_1935[]::new));
        }

        static RecipeInput of(class_2960 tag) {
            return new RecipeInput(List.of(new Entry(null, tag)));
        }

        static RecipeInput of(class_6862<class_1792> tag) {
            return RecipeInput.of(tag.comp_327());
        }

        private record Entry(class_1935 item, class_2960 tag) {
        }
    }

    protected static class ShapelessRecipeBuilder
    extends RecipeBuilder<ShapelessRecipeBuilder> {
        private final List<RecipeInput> inputs = new ArrayList<RecipeInput>();

        private ShapelessRecipeBuilder(class_2960 identifier, class_1935 output, class_9326 outputComponents, int outputCount) {
            super(identifier, class_1865.field_9031, output, outputComponents, outputCount);
        }

        private ShapelessRecipeBuilder input(RecipeInput input, int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("Cannot add an ingredient '" + count + "' times to recipe '" + String.valueOf(this.identifier) + "'!");
            }
            if (this.inputs.size() + count > 9) {
                throw new RuntimeException("Recipe '" + String.valueOf(this.identifier) + "' can have at most 9 inputs!");
            }
            for (int i = 0; i < count; ++i) {
                this.inputs.add(input);
            }
            return this;
        }

        public ShapelessRecipeBuilder input(class_1935 item, int count) {
            return this.input(RecipeInput.of(item), count);
        }

        public ShapelessRecipeBuilder input(class_1935 item) {
            return this.input(item, 1);
        }

        public ShapelessRecipeBuilder input(class_1799 itemStack, int count) {
            return this.input(RecipeInput.of(itemStack), count);
        }

        public ShapelessRecipeBuilder input(class_1799 itemStack) {
            return this.input(itemStack, 1);
        }

        public ShapelessRecipeBuilder input(class_6862<class_1792> tag, int count) {
            return this.input(RecipeInput.of(tag), count);
        }

        public ShapelessRecipeBuilder input(class_6862<class_1792> tag) {
            return this.input(RecipeInput.of(tag), 1);
        }

        public ShapelessRecipeBuilder inputs(class_1935 ... items) {
            for (class_1935 item : items) {
                this.input(item);
            }
            return this;
        }

        public ShapelessRecipeBuilder inputs(class_1799 ... itemStacks) {
            for (class_1799 itemStack : itemStacks) {
                this.input(itemStack);
            }
            return this;
        }
    }

    protected static class SmeltingRecipeBuilder
    extends RecipeBuilder<SmeltingRecipeBuilder> {
        private boolean includeSmelting;
        private boolean includeBlasting;
        private boolean includeCampfire;
        private boolean includeSmoking;
        private RecipeInput input;
        private int experience;
        private int duration = 200;

        private SmeltingRecipeBuilder(class_2960 identifier, class_1935 output, class_9326 outputComponents, int count) {
            super(identifier, class_1865.field_9042, output, outputComponents, count);
        }

        public SmeltingRecipeBuilder includeSmelting(boolean includeSmelting) {
            this.includeSmelting = includeSmelting;
            return this;
        }

        public SmeltingRecipeBuilder includeSmelting() {
            return this.includeSmelting(true);
        }

        public SmeltingRecipeBuilder includeBlasting(boolean includeBlasting) {
            this.includeBlasting = includeBlasting;
            return this;
        }

        public SmeltingRecipeBuilder includeBlasting() {
            return this.includeBlasting(true);
        }

        public SmeltingRecipeBuilder includeCampfire(boolean includeCampfire) {
            this.includeCampfire = includeCampfire;
            return this;
        }

        public SmeltingRecipeBuilder includeCampfire() {
            return this.includeCampfire(true);
        }

        public SmeltingRecipeBuilder includeSmoking(boolean includeSmoking) {
            this.includeSmoking = includeSmoking;
            return this;
        }

        public SmeltingRecipeBuilder includeSmoking() {
            return this.includeSmoking(true);
        }

        private SmeltingRecipeBuilder input(RecipeInput input) {
            this.input = input;
            return this;
        }

        public SmeltingRecipeBuilder input(class_1935 ... items) {
            return this.input(RecipeInput.of(items));
        }

        public SmeltingRecipeBuilder input(class_1799 ... itemStacks) {
            return this.input(RecipeInput.of(itemStacks));
        }

        public SmeltingRecipeBuilder input(class_6862<class_1792> tag) {
            return this.input(RecipeInput.of(tag));
        }

        public SmeltingRecipeBuilder experience(int experience) {
            if (experience < 0) {
                throw new IllegalArgumentException("Experience for recipe '" + String.valueOf(this.identifier) + "' cannot be negative!");
            }
            this.experience = experience;
            return this;
        }

        public SmeltingRecipeBuilder duration(int ticks) {
            if (ticks <= 0) {
                throw new IllegalArgumentException("Duration for recipe '" + String.valueOf(this.identifier) + "' must be greater than 0!");
            }
            this.duration = ticks;
            return this;
        }

        public SmeltingRecipeBuilder durationSeconds(int seconds) {
            return this.duration(seconds * 20);
        }
    }

    protected static class SmithingRecipeBuilder
    extends RecipeBuilder<SmithingRecipeBuilder> {
        private RecipeInput base;
        private RecipeInput addition;

        private SmithingRecipeBuilder(class_2960 identifier, class_1935 output, class_9326 outputComponents, int outputCount) {
            super(identifier, class_1865.field_42027, output, outputComponents, outputCount);
        }

        private SmithingRecipeBuilder base(RecipeInput input) {
            this.base = input;
            return this;
        }

        public SmithingRecipeBuilder base(class_1935 ... items) {
            return this.base(RecipeInput.of(items));
        }

        public SmithingRecipeBuilder base(class_1799 ... itemStacks) {
            return this.base(RecipeInput.of(itemStacks));
        }

        public SmithingRecipeBuilder base(class_6862<class_1792> tag) {
            return this.base(RecipeInput.of(tag));
        }

        private SmithingRecipeBuilder addition(RecipeInput input) {
            this.addition = input;
            return this;
        }

        public SmithingRecipeBuilder addition(class_1935 ... items) {
            return this.addition(RecipeInput.of(items));
        }

        public SmithingRecipeBuilder addition(class_1799 ... itemStacks) {
            return this.addition(RecipeInput.of(itemStacks));
        }

        public SmithingRecipeBuilder addition(class_6862<class_1792> tag) {
            return this.addition(RecipeInput.of(tag));
        }
    }

    protected static class StoneCuttingRecipeBuilder
    extends RecipeBuilder<StoneCuttingRecipeBuilder> {
        private RecipeInput input;

        private StoneCuttingRecipeBuilder(class_2960 identifier, class_1935 output, int outputCount) {
            super(identifier, class_1865.field_17640, output, null, outputCount);
        }

        private StoneCuttingRecipeBuilder input(RecipeInput input) {
            this.input = input;
            return this;
        }

        public StoneCuttingRecipeBuilder input(class_1935 ... items) {
            return this.input(RecipeInput.of(items));
        }

        public StoneCuttingRecipeBuilder input(class_1799 ... itemStacks) {
            return this.input(RecipeInput.of(itemStacks));
        }

        public StoneCuttingRecipeBuilder input(class_6862<class_1792> tag) {
            return this.input(RecipeInput.of(tag));
        }
    }
}

