/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.AtlasSourceGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_1100;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_804;
import net.minecraft.class_811;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class ModelGenerator
extends ResourceGenerator {
    private final Map<class_2960, ModelBuilder> models = new HashMap<class_2960, ModelBuilder>();
    private final ModelAtlasSourceGenerator atlasSourceGenerator;

    public ModelGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
        this.atlasSourceGenerator = new ModelAtlasSourceGenerator(modid, cache);
    }

    @Override
    public void save() {
        this.atlasSourceGenerator.generate();
        this.atlasSourceGenerator.save();
        for (ModelBuilder modelBuilder : this.models.values()) {
            JsonObject json = this.convertToJson(modelBuilder);
            class_2960 identifier = modelBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.ASSET, json, identifier.method_12836(), "models", identifier.method_12832());
        }
    }

    protected JsonObject convertToJson(ModelBuilder modelBuilder) {
        JsonObject json = new JsonObject();
        class_2960 parentModel = modelBuilder.parent;
        if (parentModel != null) {
            if (!this.models.containsKey(parentModel) && !this.cache.doesResourceExist(ResourceType.ASSET, parentModel.method_12836(), "models", parentModel.method_12832(), ".json")) {
                throw new RuntimeException("Could find parent model '" + String.valueOf(parentModel) + "' for model '" + String.valueOf(modelBuilder.identifier) + "'!");
            }
            json.addProperty("parent", parentModel.toString());
        }
        if (modelBuilder.renderType != null) {
            json.addProperty("render_type", modelBuilder.renderType.toString());
        }
        if (!modelBuilder.ambientOcclusion) {
            json.addProperty("ambientocclusion", Boolean.valueOf(false));
        }
        if (!modelBuilder.transforms.isEmpty()) {
            JsonObject displayJson = new JsonObject();
            for (Map.Entry<class_811, TransformBuilder> entry : modelBuilder.transforms.entrySet()) {
                JsonObject transformJson = new JsonObject();
                transformJson.add("rotation", (JsonElement)ModelGenerator.createJsonArray(entry.getValue().rotation.x(), entry.getValue().rotation.y(), entry.getValue().rotation.z()));
                transformJson.add("translation", (JsonElement)ModelGenerator.createJsonArray(entry.getValue().translation.x(), entry.getValue().translation.y(), entry.getValue().translation.z()));
                transformJson.add("scale", (JsonElement)ModelGenerator.createJsonArray(entry.getValue().scale.x(), entry.getValue().scale.y(), entry.getValue().scale.z()));
                String transformName = "unknown";
                if (entry.getKey() == class_811.field_4315) {
                    transformName = "none";
                } else if (entry.getKey() == class_811.field_4323) {
                    transformName = "thirdperson_lefthand";
                } else if (entry.getKey() == class_811.field_4320) {
                    transformName = "thirdperson_righthand";
                } else if (entry.getKey() == class_811.field_4321) {
                    transformName = "firstperson_lefthand";
                } else if (entry.getKey() == class_811.field_4322) {
                    transformName = "firstperson_righthand";
                } else if (entry.getKey() == class_811.field_4316) {
                    transformName = "head";
                } else if (entry.getKey() == class_811.field_4317) {
                    transformName = "gui";
                } else if (entry.getKey() == class_811.field_4318) {
                    transformName = "ground";
                } else if (entry.getKey() == class_811.field_4319) {
                    transformName = "fixed";
                }
                displayJson.add(transformName, (JsonElement)transformJson);
            }
            json.add("display", (JsonElement)displayJson);
        }
        if (!modelBuilder.textures.isEmpty()) {
            JsonObject texturesJson = new JsonObject();
            for (Map.Entry<Object, Object> entry : modelBuilder.textures.entrySet()) {
                class_2960 texture;
                if (((String)entry.getValue()).charAt(0) != '#' && !this.cache.doesResourceExist(ResourceType.ASSET, (texture = class_2960.method_60654((String)((String)entry.getValue()))).method_12836(), "textures", texture.method_12832(), ".png")) {
                    throw new IllegalArgumentException("Could not find texture '" + String.valueOf(texture) + "' for model '" + String.valueOf(modelBuilder.identifier) + "'!");
                }
                texturesJson.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            json.add("textures", (JsonElement)texturesJson);
        }
        if (modelBuilder.lighting != null) {
            json.addProperty("gui_light", modelBuilder.lighting == class_1100.class_4751.field_21858 ? "front" : "side");
        }
        if (!modelBuilder.elements.isEmpty()) {
            JsonArray elementsJson = new JsonArray();
            for (ElementBuilder elementBuilder : modelBuilder.elements) {
                JsonObject facesJson;
                JsonObject elementJson = new JsonObject();
                elementJson.add("from", (JsonElement)ModelGenerator.createJsonArray(elementBuilder.from.x(), elementBuilder.from.y(), elementBuilder.from.z()));
                elementJson.add("to", (JsonElement)ModelGenerator.createJsonArray(elementBuilder.to.x(), elementBuilder.to.y(), elementBuilder.to.z()));
                if (elementBuilder.rotation != null) {
                    JsonObject rotationJson = new JsonObject();
                    rotationJson.add("origin", (JsonElement)ModelGenerator.createJsonArray(elementBuilder.rotation.origin.x(), elementBuilder.rotation.origin.y(), elementBuilder.rotation.origin.z()));
                    rotationJson.addProperty("axis", elementBuilder.rotation.axis.method_15434());
                    rotationJson.addProperty("angle", (Number)Float.valueOf(elementBuilder.rotation.angle));
                    rotationJson.addProperty("rescale", Boolean.valueOf(elementBuilder.rotation.rescale));
                    elementJson.add("rotation", (JsonElement)rotationJson);
                }
                if (!elementBuilder.shading) {
                    elementJson.addProperty("shade", Boolean.valueOf(false));
                }
                if (!elementBuilder.faces.isEmpty()) {
                    facesJson = new JsonObject();
                    for (Map.Entry<class_2350, FaceBuilder> entry : elementBuilder.faces.entrySet()) {
                        JsonObject faceJson = new JsonObject();
                        if (entry.getValue().texture == null) {
                            throw new RuntimeException("Model '" + String.valueOf(modelBuilder.identifier) + "' has face without a texture!");
                        }
                        faceJson.addProperty("texture", entry.getValue().texture);
                        if (entry.getValue().uv != null) {
                            faceJson.add("uv", (JsonElement)ModelGenerator.createJsonArray(entry.getValue().uv));
                        }
                        if (entry.getValue().cullface != null) {
                            faceJson.addProperty("cullface", entry.getValue().cullface.method_15434());
                        }
                        if (entry.getValue().emissivity != 0) {
                            faceJson.addProperty("emissivity", (Number)entry.getValue().emissivity);
                        }
                        if (entry.getValue().rotation != 0) {
                            faceJson.addProperty("rotation", (Number)entry.getValue().rotation);
                        }
                        if (entry.getValue().tintIndex != -1) {
                            faceJson.addProperty("tintindex", (Number)entry.getValue().tintIndex);
                        }
                        facesJson.add(entry.getKey().method_15434(), (JsonElement)faceJson);
                    }
                } else {
                    throw new RuntimeException("Element in model '" + String.valueOf(modelBuilder.identifier) + "' has no faces!");
                }
                elementJson.add("faces", (JsonElement)facesJson);
                elementsJson.add((JsonElement)elementJson);
            }
            json.add("elements", (JsonElement)elementsJson);
        }
        return json;
    }

    private static JsonArray createJsonArray(float ... elements) {
        JsonArray array = new JsonArray(elements.length);
        float[] fArray = elements;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float element = Float.valueOf(fArray[i]);
            array.add((Number)element);
        }
        return array;
    }

    protected ModelBuilder model(class_2960 location) {
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, location.method_12836(), "models", location.method_12832(), ".json");
        return this.models.computeIfAbsent(location, i -> new ModelBuilder(this.modid, (class_2960)i));
    }

    protected ModelBuilder model(String namespace, String path) {
        return this.model(class_2960.method_60655((String)namespace, (String)path));
    }

    protected ModelBuilder model(String location) {
        return this.model(this.modid, location);
    }

    protected ModelBuilder cube(class_2960 location, class_2960 up, class_2960 down, class_2960 north, class_2960 east, class_2960 south, class_2960 west) {
        return this.model(location).parent("minecraft", "block/cube").texture("up", up).texture("down", down).texture("north", north).texture("east", east).texture("south", south).texture("west", west);
    }

    protected ModelBuilder cube(String namespace, String path, class_2960 up, class_2960 down, class_2960 north, class_2960 east, class_2960 south, class_2960 west) {
        return this.model(namespace, path).parent("minecraft", "block/cube").texture("up", up).texture("down", down).texture("north", north).texture("east", east).texture("south", south).texture("west", west);
    }

    protected ModelBuilder cube(String location, class_2960 up, class_2960 down, class_2960 north, class_2960 east, class_2960 south, class_2960 west) {
        return this.model(location).parent("minecraft", "block/cube").texture("up", up).texture("down", down).texture("north", north).texture("east", east).texture("south", south).texture("west", west);
    }

    protected ModelBuilder cubeAll(class_2960 location, class_2960 texture) {
        return this.model(location).parent("minecraft", "block/cube_all").texture("all", texture);
    }

    protected ModelBuilder cubeAll(String namespace, String path, class_2960 texture) {
        return this.model(namespace, path).parent("minecraft", "block/cube_all").texture("all", texture);
    }

    protected ModelBuilder cubeAll(String location, class_2960 texture) {
        return this.model(location).parent("minecraft", "block/cube_all").texture("all", texture);
    }

    protected ModelBuilder slabBottom(class_2960 location, class_2960 side, class_2960 top, class_2960 bottom) {
        return this.model(location).parent("minecraft", "block/slab").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabBottom(String namespace, String path, class_2960 side, class_2960 top, class_2960 bottom) {
        return this.model(namespace, path).parent("minecraft", "block/slab").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabBottom(String location, class_2960 side, class_2960 top, class_2960 bottom) {
        return this.model(location).parent("minecraft", "block/slab").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabTop(class_2960 location, class_2960 side, class_2960 top, class_2960 bottom) {
        return this.model(location).parent("minecraft", "block/slab_top").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabTop(String namespace, String path, class_2960 side, class_2960 top, class_2960 bottom) {
        return this.model(namespace, path).parent("minecraft", "block/slab_top").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder slabTop(String location, class_2960 side, class_2960 top, class_2960 bottom) {
        return this.model(location).parent("minecraft", "block/slab_top").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder stairs(class_2960 location, class_2960 side, class_2960 top, class_2960 bottom) {
        return this.model(location).parent("minecraft", "block/stairs").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder stairs(String namespace, String path, class_2960 side, class_2960 top, class_2960 bottom) {
        return this.model(namespace, path).parent("minecraft", "block/stairs").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder stairs(String location, class_2960 side, class_2960 top, class_2960 bottom) {
        return this.model(location).parent("minecraft", "block/stairs").texture("side", side).texture("top", top).texture("bottom", bottom);
    }

    protected ModelBuilder itemGenerated(class_2960 location, class_2960 texture) {
        return this.model(location).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemGenerated(String namespace, String path, class_2960 texture) {
        return this.model(namespace, path).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemGenerated(String location, class_2960 texture) {
        return this.model(location).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemGenerated(class_1935 item, class_2960 texture) {
        class_2960 identifier = Registries.ITEMS.getIdentifier(item.method_8389());
        return this.model(identifier.method_12836(), "item/" + identifier.method_12832()).parent("minecraft", "item/generated").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(class_2960 location, class_2960 texture) {
        return this.model(location).parent("minecraft", "item/handheld").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(String namespace, String path, class_2960 texture) {
        return this.model(namespace, path).parent("minecraft", "item/handheld").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(String location, class_2960 texture) {
        return this.model(location).parent("minecraft", "item/handheld").texture("layer0", texture);
    }

    protected ModelBuilder itemHandheld(class_1935 item, class_2960 texture) {
        class_2960 identifier = Registries.ITEMS.getIdentifier(item.method_8389());
        return this.model(identifier.method_12836(), "item/" + identifier.method_12832()).parent("minecraft", "item/handheld").texture("layer0", texture);
    }

    @Override
    public String getName() {
        return this.modName + " Model Generator";
    }

    private class ModelAtlasSourceGenerator
    extends AtlasSourceGenerator {
        public ModelAtlasSourceGenerator(String modid, ResourceCache cache) {
            super(modid, cache);
        }

        @Override
        public void generate() {
            for (ModelBuilder modelBuilder : ModelGenerator.this.models.values()) {
                modelBuilder.textures.values().stream().filter(i -> i.charAt(0) != '#').map(class_2960::method_60654).forEach(this.blockAtlas()::texture);
                class_2960 parent = modelBuilder.parent;
                if (parent == null || ModelGenerator.this.models.containsKey(parent) || !this.cache.getExistingResource(ResourceType.ASSET, parent.method_12836(), "models", parent.method_12832(), ".json").isPresent()) continue;
                this.blockAtlas().texturesFromModel(modelBuilder.parent);
            }
        }
    }

    protected static class ModelBuilder {
        protected final String modid;
        protected final class_2960 identifier;
        private final Map<String, String> textures = new LinkedHashMap<String, String>();
        private final Map<class_811, TransformBuilder> transforms = new LinkedHashMap<class_811, TransformBuilder>();
        private final List<ElementBuilder> elements = new ArrayList<ElementBuilder>();
        private class_2960 parent;
        private class_2960 renderType;
        private boolean ambientOcclusion = true;
        private class_1100.class_4751 lighting = null;

        protected ModelBuilder(String modid, class_2960 identifier) {
            this.modid = modid;
            this.identifier = identifier;
        }

        public ModelBuilder parent(class_2960 model) {
            if (this.identifier.equals((Object)model)) {
                throw new IllegalArgumentException("Cannot add self as parent model '" + String.valueOf(model) + "'!");
            }
            this.parent = model;
            return this;
        }

        public ModelBuilder parent(String namespace, String path) {
            return this.parent(class_2960.method_60655((String)namespace, (String)path));
        }

        public ModelBuilder parent(String model) {
            return this.parent(this.modid, model);
        }

        public ModelBuilder ambientOcclusion(boolean useAmbientOcclusion) {
            this.ambientOcclusion = useAmbientOcclusion;
            return this;
        }

        public ModelBuilder noAmbientOcclusion() {
            return this.ambientOcclusion(false);
        }

        public ModelBuilder frontLit() {
            this.lighting = class_1100.class_4751.field_21858;
            return this;
        }

        public ModelBuilder sideLit() {
            this.lighting = class_1100.class_4751.field_21859;
            return this;
        }

        public ModelBuilder texture(String key, class_2960 texture) {
            this.textures.put(key, texture.toString());
            return this;
        }

        public ModelBuilder texture(String key, String texture) {
            if (texture.charAt(0) != '#' && !RegistryUtil.isValidIdentifier(texture)) {
                throw new IllegalArgumentException("Texture entry must either start with '#' or be a valid resource location, not '" + texture + "'!");
            }
            if (texture.charAt(0) != '#') {
                return this.texture(key, texture.contains(":") ? class_2960.method_60654((String)texture) : class_2960.method_60655((String)this.modid, (String)texture));
            }
            this.textures.put(key, texture);
            return this;
        }

        public ModelBuilder texture(String key, String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.texture(key, class_2960.method_60655((String)namespace, (String)identifier));
            return this;
        }

        public ModelBuilder particleTexture(class_2960 texture) {
            return this.texture("particle", texture);
        }

        public ModelBuilder particleTexture(String texture) {
            return this.texture("particle", texture);
        }

        public ModelBuilder particleTexture(String namespace, String identifier) {
            return this.texture("particle", namespace, identifier);
        }

        public ModelBuilder transform(class_811 transformType, Consumer<TransformBuilder> transformBuilderConsumer) {
            transformBuilderConsumer.accept(this.transforms.computeIfAbsent(transformType, o -> new TransformBuilder()));
            return this;
        }

        public ModelBuilder element(Consumer<ElementBuilder> elementBuilderConsumer) {
            ElementBuilder builder = new ElementBuilder();
            elementBuilderConsumer.accept(builder);
            this.elements.add(builder);
            return this;
        }
    }

    protected static class TransformBuilder {
        private Vector3f rotation = new Vector3f((Vector3fc)class_804.class_805.field_4288);
        private Vector3f translation = new Vector3f((Vector3fc)class_804.class_805.field_4290);
        private Vector3f scale = new Vector3f((Vector3fc)class_804.class_805.field_4289);

        protected TransformBuilder() {
        }

        public TransformBuilder rotation(float x, float y, float z) {
            this.rotation = new Vector3f(x, y, z);
            return this;
        }

        public TransformBuilder translation(float x, float y, float z) {
            this.translation = new Vector3f(x, y, z);
            return this;
        }

        public TransformBuilder scale(float x, float y, float z) {
            this.scale = new Vector3f(x, y, z);
            return this;
        }

        public TransformBuilder scale(float scale) {
            return this.scale(scale, scale, scale);
        }
    }

    protected static class ElementBuilder {
        private final Map<class_2350, FaceBuilder> faces = new HashMap<class_2350, FaceBuilder>();
        private Vector3f from = new Vector3f();
        private Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        private RotationBuilder rotation;
        private boolean shading = true;

        protected ElementBuilder() {
        }

        public ElementBuilder from(Vector3f from) {
            this.from = from;
            return this;
        }

        public ElementBuilder from(float x, float y, float z) {
            return this.from(new Vector3f(x, y, z));
        }

        public ElementBuilder to(Vector3f to) {
            this.to = to;
            return this;
        }

        public ElementBuilder to(float x, float y, float z) {
            return this.to(new Vector3f(x, y, z));
        }

        public ElementBuilder shape(Vector3f from, Vector3f to) {
            this.from(from);
            this.to(to);
            return this;
        }

        public ElementBuilder shape(float minX, float minY, int minZ, float maxX, float maxY, float maxZ) {
            return this.shape(new Vector3f(minX, minY, (float)minZ), new Vector3f(maxX, maxY, maxZ));
        }

        public ElementBuilder shading(boolean doShading) {
            this.shading = doShading;
            return this;
        }

        public ElementBuilder noShading() {
            return this.shading(false);
        }

        public ElementBuilder face(class_2350 side, Consumer<FaceBuilder> faceBuilderConsumer) {
            faceBuilderConsumer.accept(this.faces.computeIfAbsent(side, FaceBuilder::new));
            return this;
        }

        public ElementBuilder allFaces(BiFunction<class_2350, FaceBuilder, Boolean> faceBuilderFunction) {
            for (class_2350 side : class_2350.values()) {
                if (faceBuilderFunction.apply(side, this.faces.computeIfAbsent(side, FaceBuilder::new)).booleanValue()) continue;
                this.faces.remove(side);
            }
            return this;
        }

        public ElementBuilder allFaces(BiConsumer<class_2350, FaceBuilder> faceBuilderConsumer) {
            return this.allFaces((class_2350 direction, FaceBuilder faceBuilder) -> {
                faceBuilderConsumer.accept((class_2350)direction, (FaceBuilder)faceBuilder);
                return true;
            });
        }

        public ElementBuilder allFaces(Consumer<FaceBuilder> faceBuilderConsumer) {
            return this.allFaces((class_2350 direction, FaceBuilder faceBuilder) -> {
                faceBuilderConsumer.accept((FaceBuilder)faceBuilder);
                return true;
            });
        }

        public ElementBuilder rotation(Consumer<RotationBuilder> rotationBuilderConsumer) {
            if (this.rotation == null) {
                this.rotation = new RotationBuilder();
            }
            rotationBuilderConsumer.accept(this.rotation);
            return this;
        }
    }

    protected static class RotationBuilder {
        private Vector3f origin;
        private class_2350.class_2351 axis;
        private float angle;
        private boolean rescale;

        protected RotationBuilder() {
        }

        public RotationBuilder origin(Vector3f origin) {
            this.origin = origin;
            return this;
        }

        public RotationBuilder origin(float x, float y, float z) {
            return this.origin(new Vector3f(x, y, z));
        }

        public RotationBuilder axis(class_2350.class_2351 axis) {
            this.axis = axis;
            return this;
        }

        public RotationBuilder angle(float angle) {
            if (angle != 0.0f && Math.abs(angle) != 22.5f && Math.abs(angle) != 45.0f) {
                throw new IllegalArgumentException("Angle must be one of -45, -22.5, 0, 22.5, or 45, not '" + angle + "'!");
            }
            this.angle = angle;
            return this;
        }

        public RotationBuilder rescale(boolean rescale) {
            this.rescale = rescale;
            return this;
        }

        public RotationBuilder rescale() {
            return this.rescale(true);
        }
    }

    protected static class FaceBuilder {
        private final class_2350 side;
        private float[] uv;
        private String texture;
        private class_2350 cullface;
        private int rotation = 0;
        private int tintIndex = -1;
        private int emissivity = 0;

        protected FaceBuilder(class_2350 side) {
            this.side = side;
        }

        public FaceBuilder uv(float minX, float minY, float maxX, float maxY) {
            this.uv = new float[]{minX, minY, maxX, maxY};
            return this;
        }

        public FaceBuilder texture(String reference) {
            if (!(reference.charAt(0) == '#' ? reference.substring(1) : reference).matches("[a-zA-Z_-]*")) {
                throw new IllegalArgumentException("Texture reference '" + reference + "' must only contain characters [a-zA-Z_-]!");
            }
            this.texture = reference.charAt(0) == '#' ? reference : "#" + reference;
            return this;
        }

        public FaceBuilder cullface(class_2350 side) {
            this.cullface = side;
            return this;
        }

        public FaceBuilder cullface() {
            this.cullface(this.side);
            return this;
        }

        public FaceBuilder rotation(int rotation) {
            if (rotation % 90 != 0) {
                throw new IllegalArgumentException("Rotation must be a multiple of 90, not '" + rotation + "'!");
            }
            this.rotation = rotation;
            return this;
        }

        public FaceBuilder tintIndex(int index) {
            this.tintIndex = index;
            return this;
        }

        public FaceBuilder emissivity(int emissivity) {
            if (emissivity < 0 || emissivity > 15) {
                throw new IllegalArgumentException("Emissivity must be between 0 and 15, not '" + emissivity + "'!");
            }
            this.emissivity = emissivity;
            return this;
        }
    }
}

