/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.AtlasSourceAggregator;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.TextureAtlases;
import com.supermartijn642.core.util.Pair;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;

public abstract class AtlasSourceGenerator
extends ResourceGenerator {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private final Map<class_2960, AtlasBuilder> builders = new HashMap<class_2960, AtlasBuilder>();

    public AtlasSourceGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (Map.Entry<class_2960, AtlasBuilder> atlas : this.builders.entrySet()) {
            Set<class_2960> textures = this.gatherTextures(atlas.getValue());
            class_2960 identifier = atlas.getKey();
            this.cache.saveResource(ResourceType.ASSET, AtlasSourceAggregator.INSTANCE, textures, identifier.method_12836(), "atlases", identifier.method_12832(), ".json");
        }
    }

    private Set<class_2960> gatherTextures(AtlasBuilder builder) {
        class_2960 parent;
        HashSet<class_2960> textures = new HashSet<class_2960>(builder.textures);
        HashSet<class_2960> parents = new HashSet<class_2960>();
        for (Pair<class_2960, Boolean> pair2 : builder.models) {
            parent = this.readModelData(pair2.left(), true, textures);
            if (parent == null || !pair2.right().booleanValue()) continue;
            parents.add(parent);
        }
        HashSet<class_2960> done = new HashSet<class_2960>();
        builder.models.forEach(pair -> done.add((class_2960)pair.left()));
        while (!parents.isEmpty()) {
            class_2960 class_29602 = (class_2960)parents.iterator().next();
            parents.remove(class_29602);
            done.add(class_29602);
            parent = this.readModelData(class_29602, false, textures);
            if (parent == null || done.contains(parent)) continue;
            parents.add(parent);
        }
        return textures;
    }

    private class_2960 readModelData(class_2960 model, boolean forced, Set<class_2960> textures) {
        Optional<InputStream> optional = this.cache.getExistingResource(ResourceType.ASSET, model.method_12836(), "models", model.method_12832(), ".json");
        if (optional.isEmpty()) {
            if (forced) {
                throw new RuntimeException("Could not find model '" + String.valueOf(model) + "' to read textures from!");
            }
            return null;
        }
        class_2960 parent = null;
        try {
            String identifier;
            JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(optional.get()), JsonObject.class);
            if (json.has("parent") && json.get("parent").isJsonPrimitive() && json.getAsJsonPrimitive("parent").isString() && RegistryUtil.isValidIdentifier(identifier = json.get("parent").getAsString())) {
                parent = class_2960.method_60654((String)identifier);
            }
            if (json.has("textures") && json.get("textures").isJsonObject()) {
                for (Map.Entry texture : json.getAsJsonObject("textures").entrySet()) {
                    String identifier2;
                    if (!((JsonElement)texture.getValue()).isJsonPrimitive() || !((JsonElement)texture.getValue()).getAsJsonPrimitive().isString() || !RegistryUtil.isValidIdentifier(identifier2 = ((JsonElement)texture.getValue()).getAsString())) continue;
                    textures.add(class_2960.method_60654((String)identifier2));
                }
            }
        }
        catch (Exception ignore) {
            return null;
        }
        return parent;
    }

    protected AtlasBuilder atlas(class_2960 identifier) {
        if (identifier.method_12832().startsWith("textures/atlas/") && identifier.method_12832().endsWith(".png")) {
            identifier = class_2960.method_60655((String)identifier.method_12836(), (String)identifier.method_12832().substring("textures/atlas/".length(), identifier.method_12832().length() - ".png".length()));
        }
        return this.builders.computeIfAbsent(identifier, i -> new AtlasBuilder(this.modid, (class_2960)i));
    }

    protected AtlasBuilder atlas(String namespace, String identifier) {
        return this.atlas(class_2960.method_60655((String)namespace, (String)identifier));
    }

    protected AtlasBuilder atlas(String identifier) {
        return this.atlas(this.modid, identifier);
    }

    protected AtlasBuilder blockAtlas() {
        return this.atlas(TextureAtlases.getBlocks());
    }

    protected AtlasBuilder guiAtlas() {
        return this.atlas(TextureAtlases.getGUI());
    }

    @Override
    public String getName() {
        return this.modName + " Atlas Source Generator";
    }

    public static class AtlasBuilder {
        private final String modid;
        private final class_2960 identifier;
        private final Set<class_2960> textures = new HashSet<class_2960>();
        private final List<Pair<class_2960, Boolean>> models = new ArrayList<Pair<class_2960, Boolean>>();

        private AtlasBuilder(String modid, class_2960 identifier) {
            this.modid = modid;
            this.identifier = identifier;
        }

        public AtlasBuilder texture(class_2960 location) {
            this.textures.add(location);
            return this;
        }

        public AtlasBuilder texture(String namespace, String path) {
            return this.texture(class_2960.method_60655((String)namespace, (String)path));
        }

        public AtlasBuilder texture(String path) {
            return this.texture(this.modid, path);
        }

        public AtlasBuilder texturesFromModel(class_2960 model, boolean includeParents) {
            this.models.add(Pair.of(model, includeParents));
            return this;
        }

        public AtlasBuilder texturesFromModel(String namespace, String path, boolean includeParents) {
            return this.texturesFromModel(class_2960.method_60655((String)namespace, (String)path), includeParents);
        }

        public AtlasBuilder texturesFromModel(String path, boolean includeParents) {
            return this.texturesFromModel(this.modid, path, includeParents);
        }

        public AtlasBuilder texturesFromModel(class_2960 model) {
            return this.texturesFromModel(model, true);
        }

        public AtlasBuilder texturesFromModel(String namespace, String path) {
            return this.texturesFromModel(namespace, path, true);
        }

        public AtlasBuilder texturesFromModel(String path) {
            return this.texturesFromModel(path, true);
        }
    }
}

