/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.NotResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_175;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

public abstract class AdvancementGenerator
extends ResourceGenerator {
    private final Map<class_2960, AdvancementBuilder> advancements = new HashMap<class_2960, AdvancementBuilder>();

    public AdvancementGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        class_6903 ops = ResourceGenerator.registryAccess.method_57093((DynamicOps)JsonOps.INSTANCE);
        for (AdvancementBuilder advancementBuilder : this.advancements.values()) {
            if (advancementBuilder.criteria.isEmpty()) {
                throw new RuntimeException("Advancement '" + String.valueOf(advancementBuilder.identifier) + "' does not have any criteria!");
            }
            if (advancementBuilder.requirements.isEmpty()) {
                if (advancementBuilder.criteria.size() != 1) {
                    throw new RuntimeException("Advancement '" + String.valueOf(advancementBuilder.identifier) + "' does not have any requirements set!");
                }
                advancementBuilder.requirements.add((String[])advancementBuilder.criteria.keySet().toArray(String[]::new));
            }
            for (String criterion2 : (String[])advancementBuilder.requirements.stream().flatMap(Arrays::stream).toArray(String[]::new)) {
                if (advancementBuilder.criteria.containsKey(criterion2)) continue;
                throw new RuntimeException("Found requirement for unknown criterion '" + criterion2 + "' in advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
            }
            JsonObject json = new JsonObject();
            if (!advancementBuilder.conditions.isEmpty()) {
                JsonArray conditionsJson = new JsonArray();
                for (ResourceCondition condition : advancementBuilder.conditions) {
                    JsonObject conditionJson = new JsonObject();
                    conditionJson.addProperty("condition", Registries.RESOURCE_CONDITION_SERIALIZERS.getIdentifier(condition.getSerializer()).toString());
                    condition.getSerializer().serialize(conditionJson, condition);
                    conditionsJson.add((JsonElement)conditionJson);
                }
                json.add("fabric:load_conditions", (JsonElement)conditionsJson);
            }
            if (advancementBuilder.parent != null) {
                class_2960 parent = advancementBuilder.parent;
                if (!this.advancements.containsKey(parent) && !this.cache.doesResourceExist(ResourceType.DATA, parent.method_12836(), "advancement", parent.method_12832(), ".json")) {
                    throw new RuntimeException("Could not find parent '" + String.valueOf(parent) + "' for advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
                }
                json.addProperty("parent", parent.toString());
            }
            JsonObject displayJson = new JsonObject();
            if (advancementBuilder.icon == null && !class_2960.method_60655((String)"minecraft", (String)"recipes/root").equals((Object)advancementBuilder.parent)) {
                throw new RuntimeException("Advancement '" + String.valueOf(advancementBuilder.identifier) + "' must have an icon!");
            }
            if (advancementBuilder.icon != null) {
                JsonObject iconJson = new JsonObject();
                iconJson.addProperty("id", Registries.ITEMS.getIdentifier(advancementBuilder.icon).toString());
                if (advancementBuilder.iconComponents != null && !advancementBuilder.iconComponents.method_57848()) {
                    iconJson.add("components", (JsonElement)class_9326.field_49589.encodeStart((DynamicOps)ops, (Object)advancementBuilder.iconComponents).getOrThrow());
                }
                displayJson.add("icon", (JsonElement)iconJson);
            }
            JsonObject titleJson = new JsonObject();
            titleJson.addProperty("translate", advancementBuilder.titleKey);
            displayJson.add("title", (JsonElement)titleJson);
            JsonObject description = new JsonObject();
            description.addProperty("translate", advancementBuilder.descriptionKey);
            displayJson.add("description", (JsonElement)description);
            displayJson.addProperty("frame", advancementBuilder.frame.method_15434());
            if (advancementBuilder.background != null) {
                if (!this.cache.doesResourceExist(ResourceType.ASSET, advancementBuilder.background.method_12836(), "textures", advancementBuilder.background.method_12832(), ".png")) {
                    throw new RuntimeException("Could not find background texture '" + String.valueOf(advancementBuilder.background) + "' for advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
                }
                displayJson.addProperty("background", advancementBuilder.background.method_12836() + ":textures/" + advancementBuilder.background.method_12832() + ".png");
            }
            displayJson.addProperty("show_toast", Boolean.valueOf(advancementBuilder.showToast));
            displayJson.addProperty("announce_to_chat", Boolean.valueOf(advancementBuilder.announceToChat));
            displayJson.addProperty("hidden", Boolean.valueOf(advancementBuilder.hidden));
            json.add("display", (JsonElement)displayJson);
            JsonObject criteriaJson = new JsonObject();
            for (Map.Entry<String, Pair<class_179<?>, class_184>> entry : advancementBuilder.criteria.entrySet()) {
                JsonObject criterionJson = new JsonObject();
                criterionJson.addProperty("trigger", class_7923.field_47496.method_10221(entry.getValue().left()).toString());
                JsonElement conditionsJson = (JsonElement)entry.getValue().left().method_54937().encodeStart((DynamicOps)ops, (Object)entry.getValue().right()).getOrThrow();
                if (!conditionsJson.isJsonObject() || !conditionsJson.getAsJsonObject().isEmpty()) {
                    criterionJson.add("conditions", conditionsJson);
                }
                criteriaJson.add(entry.getKey(), (JsonElement)criterionJson);
            }
            json.add("criteria", (JsonElement)criteriaJson);
            JsonArray requirementsArray = new JsonArray();
            for (String[] requirementGroup : advancementBuilder.requirements) {
                JsonArray groupArray = new JsonArray();
                Arrays.stream(requirementGroup).forEach(arg_0 -> ((JsonArray)groupArray).add(arg_0));
                requirementsArray.add((JsonElement)groupArray);
            }
            json.add("requirements", (JsonElement)requirementsArray);
            JsonObject jsonObject = new JsonObject();
            if (!advancementBuilder.rewardRecipes.isEmpty()) {
                JsonArray recipesJson = new JsonArray();
                for (class_2960 rewardRecipe : advancementBuilder.rewardRecipes) {
                    if (!this.cache.doesResourceExist(ResourceType.DATA, rewardRecipe.method_12836(), "recipe", rewardRecipe.method_12832(), ".json")) {
                        throw new RuntimeException("Could not find reward recipe '" + String.valueOf(rewardRecipe) + "' for advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
                    }
                    recipesJson.add(rewardRecipe.toString());
                }
                jsonObject.add("recipes", (JsonElement)recipesJson);
            }
            if (!advancementBuilder.rewardLootTables.isEmpty()) {
                JsonArray lootTablesJson = new JsonArray();
                for (class_2960 rewardLootTable : advancementBuilder.rewardLootTables) {
                    if (!this.cache.doesResourceExist(ResourceType.DATA, rewardLootTable.method_12836(), "loot_tables", rewardLootTable.method_12832(), ".json")) {
                        throw new RuntimeException("Could not find reward loot table '" + String.valueOf(rewardLootTable) + "' for advancement '" + String.valueOf(advancementBuilder.identifier) + "'!");
                    }
                    lootTablesJson.add(rewardLootTable.toString());
                }
                jsonObject.add("loot", (JsonElement)lootTablesJson);
            }
            if (advancementBuilder.rewardExperience != 0) {
                jsonObject.addProperty("experience", (Number)advancementBuilder.rewardExperience);
            }
            if (jsonObject.size() != 0) {
                json.add("rewards", (JsonElement)jsonObject);
            }
            class_2960 identifier = advancementBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.DATA, json, identifier.method_12836(), "advancement", identifier.method_12832());
        }
    }

    public AdvancementBuilder advancement(class_2960 identifier) {
        if (this.advancements.containsKey(identifier)) {
            throw new RuntimeException("Duplicate advancement with identifier '" + String.valueOf(identifier) + "'!");
        }
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.method_12836(), "advancement", identifier.method_12832(), ".json");
        return this.advancements.computeIfAbsent(identifier, i -> new AdvancementBuilder(this.modid, (class_2960)i));
    }

    public AdvancementBuilder advancement(String namespace, String path) {
        return this.advancement(class_2960.method_60655((String)namespace, (String)path));
    }

    public AdvancementBuilder advancement(String identifier) {
        return this.advancement(this.modid, identifier);
    }

    @Override
    public String getName() {
        return this.modName + " Advancement Generator";
    }

    protected static class AdvancementBuilder {
        protected final String modid;
        protected final class_2960 identifier;
        private final List<ResourceCondition> conditions = new ArrayList<ResourceCondition>();
        private final Map<String, Pair<class_179<?>, class_184>> criteria = new LinkedHashMap();
        private final List<String[]> requirements = new ArrayList<String[]>();
        private final List<class_2960> rewardLootTables = new ArrayList<class_2960>();
        private final List<class_2960> rewardRecipes = new ArrayList<class_2960>();
        private class_2960 parent;
        private class_1792 icon;
        private class_9326 iconComponents;
        private String titleKey;
        private String descriptionKey;
        private class_189 frame = class_189.field_1254;
        private class_2960 background;
        private boolean showToast = true;
        private boolean announceToChat = true;
        private boolean hidden;
        private int rewardExperience;

        public AdvancementBuilder(String modid, class_2960 identifier) {
            this.modid = modid;
            this.identifier = identifier;
            this.titleKey = identifier.method_12836() + ".advancement." + identifier.method_12832() + ".title";
            this.descriptionKey = identifier.method_12836() + ".advancement." + identifier.method_12832() + ".description";
        }

        public AdvancementBuilder condition(ResourceCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public AdvancementBuilder notCondition(ResourceCondition condition) {
            return this.condition(new NotResourceCondition(condition));
        }

        public AdvancementBuilder modLoadedCondition(String modid) {
            return this.condition(new ModLoadedResourceCondition(modid));
        }

        public AdvancementBuilder parent(class_2960 advancement) {
            if (this.identifier.equals((Object)advancement)) {
                throw new IllegalArgumentException("Advancement '" + String.valueOf(this.identifier) + "' cannot have itself as parent!");
            }
            this.parent = advancement;
            return this;
        }

        public AdvancementBuilder parent(String namespace, String path) {
            return this.parent(class_2960.method_60655((String)namespace, (String)path));
        }

        public AdvancementBuilder parent(String advancement) {
            return this.parent(this.modid, advancement);
        }

        public AdvancementBuilder icon(class_1935 item, class_9326 components) {
            this.icon = item.method_8389();
            this.iconComponents = components;
            return this;
        }

        public AdvancementBuilder icon(class_1935 item) {
            return this.icon(item, null);
        }

        public AdvancementBuilder icon(class_2960 item) {
            if (!Registries.ITEMS.hasIdentifier(item)) {
                throw new IllegalArgumentException("Could not find any item registered under '" + String.valueOf(item) + "'!");
            }
            return this.icon((class_1935)Registries.ITEMS.getValue(item), null);
        }

        public AdvancementBuilder icon(String namespace, String identifier) {
            return this.icon(class_2960.method_60655((String)namespace, (String)identifier));
        }

        public AdvancementBuilder title(String translationKey) {
            if (translationKey == null || translationKey.isBlank()) {
                throw new IllegalArgumentException("Title translation key '" + translationKey + "' for advancement '" + String.valueOf(this.identifier) + "' must not be empty!");
            }
            this.titleKey = translationKey;
            return this;
        }

        public AdvancementBuilder description(String translationKey) {
            if (translationKey == null || translationKey.isBlank()) {
                throw new IllegalArgumentException("Description translation key '" + translationKey + "' for advancement '" + String.valueOf(this.identifier) + "' must not be empty!");
            }
            this.descriptionKey = translationKey;
            return this;
        }

        public AdvancementBuilder frame(class_189 frameType) {
            this.frame = frameType;
            return this;
        }

        public AdvancementBuilder challengeFrame() {
            return this.frame(class_189.field_1250);
        }

        public AdvancementBuilder goalFrame() {
            return this.frame(class_189.field_1249);
        }

        public AdvancementBuilder taskFrame() {
            return this.frame(class_189.field_1254);
        }

        public AdvancementBuilder background(class_2960 texture) {
            this.background = texture;
            return this;
        }

        public AdvancementBuilder background(String namespace, String path) {
            return this.background(class_2960.method_60655((String)namespace, (String)path));
        }

        public AdvancementBuilder showToast(boolean show) {
            this.showToast = show;
            return this;
        }

        public AdvancementBuilder dontShowToast() {
            return this.showToast(false);
        }

        public AdvancementBuilder announceToChat(boolean announce) {
            this.announceToChat = announce;
            return this;
        }

        public AdvancementBuilder dontAnnounceToChat() {
            return this.announceToChat(false);
        }

        public AdvancementBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public AdvancementBuilder hidden() {
            return this.hidden(true);
        }

        public <T extends class_184> AdvancementBuilder criterion(String name, class_179<T> criterion, T instance) {
            if (this.criteria.containsKey(name)) {
                throw new RuntimeException("Duplicate criterion with name '" + name + "' for advancement '" + String.valueOf(this.identifier) + "'!");
            }
            this.criteria.put(name, Pair.of(criterion, instance));
            return this;
        }

        public AdvancementBuilder criterion(String name, class_175<?> criterion) {
            if (this.criteria.containsKey(name)) {
                throw new RuntimeException("Duplicate criterion with name '" + name + "' for advancement '" + String.valueOf(this.identifier) + "'!");
            }
            this.criteria.put(name, Pair.of(criterion.comp_1923(), criterion.comp_1924()));
            return this;
        }

        public AdvancementBuilder hasItemsCriterion(String name, class_1935 ... items) {
            this.criterion(name, class_2066.class_2068.method_8959((class_1935[])items));
            return this;
        }

        public AdvancementBuilder requirementGroup(String ... criteria) {
            if (this.requirements.contains(criteria)) {
                throw new RuntimeException("Duplicate requirement group '" + Arrays.toString(criteria) + "' for advancement '" + String.valueOf(this.identifier) + "'!");
            }
            this.requirements.add(criteria);
            return this;
        }

        public AdvancementBuilder requirements(String[] ... groups) {
            Arrays.stream(groups).forEach(this::requirementGroup);
            return this;
        }

        public AdvancementBuilder rewardExperience(int experience) {
            if (experience < 0) {
                throw new IllegalArgumentException("Reward experience for advancement '" + String.valueOf(this.identifier) + "' must be greater than 0, not '" + experience + "'!");
            }
            this.rewardExperience = experience;
            return this;
        }

        public AdvancementBuilder rewardLootTable(class_2960 lootTable) {
            this.rewardLootTables.add(lootTable);
            return this;
        }

        public AdvancementBuilder rewardLootTable(String namespace, String path) {
            return this.rewardLootTable(class_2960.method_60655((String)namespace, (String)path));
        }

        public AdvancementBuilder rewardRecipe(class_2960 recipe) {
            if (this.rewardRecipes.contains(recipe)) {
                throw new RuntimeException("Duplicate recipe reward '" + String.valueOf(recipe) + "' for advancement '" + String.valueOf(this.identifier) + "'!");
            }
            this.rewardRecipes.add(recipe);
            return this;
        }

        public AdvancementBuilder rewardRecipe(String namespace, String path) {
            return this.rewardRecipe(class_2960.method_60655((String)namespace, (String)path));
        }
    }
}

