/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class BlockShape {
    private final class_265 shape;

    public static BlockShape create(class_238 box) {
        return new BlockShape(box);
    }

    public static BlockShape create(class_265 box) {
        return new BlockShape(box);
    }

    public static BlockShape create(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(class_259.method_1081((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    public static BlockShape createBlockShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(class_259.method_1081((double)(x1 / 16.0), (double)(y1 / 16.0), (double)(z1 / 16.0), (double)(x2 / 16.0), (double)(y2 / 16.0), (double)(z2 / 16.0)));
    }

    public static BlockShape or(BlockShape shape, BlockShape ... shapes) {
        return new BlockShape(class_259.method_17786((class_265)shape.shape, (class_265[])((class_265[])Arrays.stream(shapes).map(s -> s.shape).toArray(class_265[]::new))));
    }

    public static BlockShape fullCube() {
        return new BlockShape(class_259.method_1077());
    }

    public static BlockShape empty() {
        return new BlockShape(class_259.method_1073());
    }

    public static boolean intersects(BlockShape shape1, BlockShape shape2) {
        return shape1.intersects(shape2);
    }

    public BlockShape(class_265 shape) {
        this.shape = shape;
    }

    public BlockShape(class_238 shape) {
        this(class_259.method_1078((class_238)shape));
    }

    public BlockShape(List<class_238> shapes) {
        this(class_259.method_17786((class_265)class_259.method_1073(), (class_265[])((class_265[])shapes.stream().map(class_259::method_1078).toArray(class_265[]::new))));
    }

    public List<class_238> toBoxes() {
        return this.shape.method_1090();
    }

    public void forEachBox(Consumer<class_238> action) {
        this.toBoxes().forEach(action);
    }

    public void forEachEdge(LineConsumer action) {
        this.shape.method_1104(action::apply);
    }

    public void forEachCorner(PointConsumer action) {
        this.shape.method_1089((x1, y1, z1, x2, y2, z2) -> {
            action.apply(x1, y1, z1);
            action.apply(x2, y1, z1);
            action.apply(x1, y1, z2);
            action.apply(x2, y1, z2);
            action.apply(x1, y2, z1);
            action.apply(x2, y2, z1);
            action.apply(x1, y2, z2);
            action.apply(x2, y2, z2);
        });
    }

    public class_238 simplify() {
        return this.shape.method_1107();
    }

    public double getStart(class_2350.class_2351 axis) {
        return this.shape.method_1091(axis);
    }

    public double getEnd(class_2350.class_2351 axis) {
        return this.shape.method_1105(axis);
    }

    public double minX() {
        return this.getStart(class_2350.class_2351.field_11048);
    }

    public double minY() {
        return this.getStart(class_2350.class_2351.field_11052);
    }

    public double minZ() {
        return this.getStart(class_2350.class_2351.field_11051);
    }

    public double maxX() {
        return this.getEnd(class_2350.class_2351.field_11048);
    }

    public double maxY() {
        return this.getEnd(class_2350.class_2351.field_11052);
    }

    public double maxZ() {
        return this.getEnd(class_2350.class_2351.field_11051);
    }

    public boolean isEmpty() {
        return this.shape.method_1110();
    }

    public BlockShape offset(double x, double y, double z) {
        return new BlockShape(this.shape.method_1096(x, y, z));
    }

    public BlockShape offset(class_2338 pos) {
        return new BlockShape(this.shape.method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
    }

    public BlockShape offset(class_2350 direction) {
        return this.offset(direction.method_10148(), direction.method_10164(), direction.method_10165());
    }

    public boolean intersects(BlockShape shape) {
        if (this.isEmpty() || shape.isEmpty()) {
            return false;
        }
        return this.maxX() > shape.minX() && this.minX() < shape.maxX() && this.maxY() > shape.minY() && this.minY() < shape.maxY() && this.maxZ() > shape.minZ() && this.minZ() < shape.maxZ();
    }

    public BlockShape grow(double amount) {
        return this.transformBoxes(box -> box.method_1014(amount));
    }

    public BlockShape shrink(double amount) {
        return this.transformBoxes(box -> box.method_1011(amount));
    }

    public BlockShape flip(class_2350.class_2351 axis) {
        return this.transformBoxes(box -> new class_238(axis == class_2350.class_2351.field_11048 ? 1.0 - box.field_1323 : box.field_1323, axis == class_2350.class_2351.field_11052 ? 1.0 - box.field_1322 : box.field_1322, axis == class_2350.class_2351.field_11051 ? 1.0 - box.field_1321 : box.field_1321, axis == class_2350.class_2351.field_11048 ? 1.0 - box.field_1320 : box.field_1320, axis == class_2350.class_2351.field_11052 ? 1.0 - box.field_1325 : box.field_1325, axis == class_2350.class_2351.field_11051 ? 1.0 - box.field_1324 : box.field_1324));
    }

    public BlockShape rotate(class_2350.class_2351 axis) {
        if (axis == null) {
            throw new IllegalArgumentException("axis must not be null!");
        }
        if (axis == class_2350.class_2351.field_11048) {
            return this.transformBoxes(box -> new class_238(box.field_1323, box.field_1321, -box.field_1322 + 1.0, box.field_1320, box.field_1324, -box.field_1325 + 1.0));
        }
        if (axis == class_2350.class_2351.field_11052) {
            return this.transformBoxes(box -> new class_238(-box.field_1321 + 1.0, box.field_1322, box.field_1323, -box.field_1324 + 1.0, box.field_1325, box.field_1320));
        }
        if (axis == class_2350.class_2351.field_11051) {
            return this.transformBoxes(box -> new class_238(box.field_1322, -box.field_1323 + 1.0, box.field_1321, box.field_1325, -box.field_1320 + 1.0, box.field_1324));
        }
        return null;
    }

    private BlockShape transformBoxes(Function<class_238, class_238> transformer) {
        return new BlockShape(this.toBoxes().stream().map(transformer::apply).collect(Collectors.toList()));
    }

    @Deprecated
    public class_265 getUnderlying() {
        return this.shape;
    }

    public static interface LineConsumer {
        public void apply(double var1, double var3, double var5, double var7, double var9, double var11);
    }

    public static interface PointConsumer {
        public void apply(double var1, double var3, double var5);
    }
}

